#include <stdio.h>
#include <mosquitto.h>
#include <pthread.h>
#include "serial.h"
#include "queue.h"
#include <time.h>
#include <string.h>

char ID[18];
int IDLE = 1;
struct mosquitto *mosq = NULL;
Queue queue;
void tokenize_and_store_in_queue(unsigned char *message);
void send_command();


void my_message_callback(struct mosquitto *mosq, void *userdata, const struct mosquitto_message *message)
{
	if(message->payloadlen){
		printf("%s %s\n", message->topic, message->payload);
		//if message->topic is "command" the payload should be queued.
		if(strcmp(message->topic,"commands") == 0){
			IDLE = 0;
			//We have received a list of commands. Lets add them to the queue.
			tokenize_and_store_in_queue(message->payload);
			//Send the first command
			send_command();
		}
	}else{
		printf("%s (null)\n", message->topic);
	}
	fflush(stdout);
}

void my_connect_callback(struct mosquitto *mosq, void *userdata, int result)
{
	if(!result){
		// result = 0. Success!
		// Login the appliance
		char loginmsg[55];
		sprintf(loginmsg,"{\"ID\":\"%s\",\"login\":\"test\",\"pass\":\"pass\"}",ID);
		mosquitto_publish(mosq,NULL,"login",55,loginmsg,1,false);
		//MAYBE IS INTERESTING TO SEND THE APPLIANCE "STATE" JUST AFTER LOGIN.
	}else{
		fprintf(stderr, "Connect failed\n");
	}
}

void my_log_callback(struct mosquitto *mosq, void *userdata, int level, const char *str)
{
	/* Print all log messages regardless of level. */
	printf("%s\n", str);
}

void get_MAC(){
  FILE *fp;
  int status;
  char path[1035];

  // Open the command for reading.
  fp = popen("ifconfig | grep HWaddr | tail -1 | awk '{print $5;}'", "r");
  if (fp == NULL) {
    printf("Failed to run command\n" );
  }

  // Read the output a line at a time - output it.
  while (fgets(path, sizeof(path)-1, fp) != NULL) {
  	path[17]='\0';
    sprintf(ID,"%s", path);
  }

  // close
  pclose(fp);
}

void tokenize_and_store_in_queue(unsigned char *message){
	char *token;

	token = strtok(message,";");
	while( token != NULL ){
		//Memory allocation for a copy of the command to be linked by the queue node
		unsigned char* command_copy = (unsigned char*) malloc(strlen(token) * sizeof(unsigned char) + 1);
		strcpy(command_copy, token);
		//Add command to the queue
		printf("TOKENIZED COMMAND: %s\n",command_copy);
		queue.push(&queue,command_copy);

		token = strtok(NULL,";");
	}
}

void send_command(){
	char *command_to_send = queue.peek(&queue);
	printf("SENDING TO ARDUINO: %s\n", command_to_send);
	serial_print_string (command_to_send);
	//serial_print('\n');
	printf("WAITING FOR A SERIAL ACK !\n");
}

//This function is called in a separate thread. It handles readings from serial port
void *serial_reads(void* p){
	
	char serial_readed[100];
	int i = 0;
	int data_to_send=0;
	struct timespec tim, tim2;
   	tim.tv_sec = 0;
   	//100 msec
   	tim.tv_nsec = 100000000L;
	while (1) {
		if(IDLE){
			//We can receive status updates or info from ATMEGA
			while(serial_available()){
				//Byte available to read in serial
				serial_readed[i] = serial_read_byte();
				i++;
				data_to_send=1;
				IDLE = 0;
			}
			
			if(data_to_send == 1){
				if(serial_readed[0] == '!'){
					//Send info to DI
					mosquitto_publish(mosq,NULL,"info",100,serial_readed,1,false);
					IDLE = 1;
					//Send SERIAL ACK
					serial_print_string("#\n");
					IDLE = 1;
				}else{
					//Send SERIAL ACK
					serial_print_string("#\n");
					//Send status update to DI
					printf("RECEIVED STATUS UPDATE FROM ARDUINO.\n");
					mosquitto_publish(mosq,NULL,"status_update",100,serial_readed,1,false);
					//Remove command from queue and send next (if any) to ATMEGA
					queue.pop(&queue);
					if(queue.size > 0){
						send_command();
					}else{
						IDLE = 1;
					}
				}
				data_to_send=0;
				i = 0;
			}
		}else{
			//Wait for SERIAL ACK from ATMEGA
			while(serial_available()){
				char byte_received = serial_read_byte();
				if (byte_received == '#'){
					serial_flush();
					printf("RECEIVED SERIAL_ACK\n" );
					IDLE = 1;
				}else{
					printf("[%c] INSTEAD OF ACK\n",byte_received);
				}
				
			}

		}
		nanosleep(&tim , &tim2);
	}
}

// Main function
int main(int argc, char *argv[]){

	serial_begin("/dev/ttyATH0",115200);
	serial_flush();
	queue = createQueue();

	char HOST_DI[] = "stark";
	int port = 1883;
	int keepalive = 60;
	bool clean_session = true;

	// MAC address is set as ID for this appliance
	get_MAC();

	// Configuration and initialization of mosquitto instance.
	mosquitto_lib_init();
	mosq = mosquitto_new(ID, clean_session, NULL);
	if(!mosq){
		fprintf(stderr, "Error: Out of memory.\n");
		return 1;
	}
	mosquitto_log_callback_set(mosq, my_log_callback);
	mosquitto_connect_callback_set(mosq, my_connect_callback);
	mosquitto_message_callback_set(mosq, my_message_callback);
	int tls_set;
	tls_set = mosquitto_tls_set(mosq,"./crt.ca.cg.pem",NULL,"./tls-cert.pem","./tls-key.pem",NULL);
	if(tls_set == MOSQ_ERR_INVAL){
		printf("TLS input parameters are invalid.\n");
	}else if(tls_set == MOSQ_ERR_NOMEM){
		printf("Out of memory.\n");
	}

	//THREAD CREATION FOR SERIAL READS
	pthread_t serial_thread;
	pthread_create(&serial_thread, NULL, &serial_reads, NULL);

	//Connect to DI. Try reconnecting in case of failure.
	if(mosquitto_connect(mosq, HOST_DI, port, keepalive)){
		//Unable to connect. We call mosquitto_reconnect in order to keep trying connection indefinitely.
		mosquitto_reconnect(mosq);
	}

	//Keep mqtt client running
	mosquitto_loop_forever(mosq, 1000,1);


	mosquitto_destroy(mosq);
	mosquitto_lib_cleanup();
	return 0;
}