#include <stdio.h>
#include <stdlib.h>

/**
 * The Node struct,
 * contains item and the pointer that point to next node.
 */
typedef struct Node {
    //int item;
    char *item;
    struct Node* next;
} Node;
/**
 * The Queue struct, contains the pointers that
 * point to first node and last node, the size of the Queue,
 * and the function pointers.
 */
typedef struct Queue {
    Node* head;
    Node* tail;

    void (*push) (struct Queue*, char *item); // add item to tail
    // get item from head and remove it from queue
    void (*pop) (struct Queue*);
    // get item from head but keep it in queue
    char *(*peek) (struct Queue*);
    // display all element in queue
    void (*display) (struct Queue*);
    // size of this queue
    int size;
} Queue;
/**
 * Push an item into queue, if this is the first item,
 * both queue->head and queue->tail will point to it,
 * otherwise the oldtail->next and tail will point to it.
 */
void push (Queue* queue, char *item);
/**
 * Return and remove the first item.
 */
void pop (Queue* queue);
/**
 * Return but not remove the first item.
 */
char *peek (Queue* queue);
/**
 * Show all items in queue.
 */
void display (Queue* queue);
/**
 * Create and initiate a Queue
 */
Queue createQueue ();
