/*
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>. 
*/

#ifndef _NWEB_H_
#define _NWEB_H_

#define VERSION 23

#define ERROR      42
#define LOG        44

typedef struct {
  int semid;
  void (*lock)();
  void (*unlock)();
} shared_access_t;

typedef void(*dfile)(int fd, char* params);

void    wlog(int type, char *s1, char *s2, int fd);
ssize_t wwrite(int fd, const void *buf, size_t count);
dfile   wopen(const char *path, int fd, void* shm);
void    wclose();
size_t  wgets(char *buf, size_t bufsize, char *name, char *params);
size_t  wmem();

#endif //_NWEB_H_