/*
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>. 
*/

// Header for platform independant serial communications
//
// senseitg@gmail.com 2012-May-22

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>

// enumerate serial devices
// fp_enum is callback to receive each device
//void senum(void (*fp_enum)(char *name,char *device));

// open serial port
// device has system dependant form
// returns true if successful
bool sopen(char* device);

// configure serial port
// fmt has form "baud,parity,databits,stopbit", ie: "9600,N,8,1"
// returns true if successful
bool sconfig(char* fmt);

// read from serial port
// returns bytes actually read
int32_t sread(void *p_read,uint16_t i_read);

// write to serial port
int32_t swrite(void* p_write,uint16_t i_write);

// close serial port
bool sclose();

// sleep milliseconds
void sdelay(unsigned long ms);

#ifdef __cplusplus
}
#endif
