/*
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>. 
*/

#ifndef LIB_HOMECHEF_H_
#define LIB_HOMECHEF_H_
#include <Arduino.h>
#include <stdint.h>
#include <inttypes.h>

#define MAX_RECIPE_SIZE 64

typedef enum {
  UPPER_LOWER,
  HOTFAN,
  LOWER_HOTFAN,
  INFRA_FAN,
  INFRA,
  LOWER_FAN,
  LOWER,
  UPPER,
  FAN,
  UPPER_INFRA_FAN,
  UPPER_INFRA,
  UPPER_HOTFAN
} heaterMode_e;


class HomeChef_Class {
public:

	byte ovenLightStatus;
	byte applicanceState;
	char recipeName[MAX_RECIPE_SIZE];
	word ovenTemperature;
	word minutesElapsed;
	word minutesRemaining;
	word temperatureSetpoint;
	byte activeHeaterSystem;
	byte meatProbeTemperature;
	byte childLockStatus;

	HomeChef_Class();

	void begin();
	boolean readStatus();
	void setOvenLight(byte request);
	void setChildLock(byte request);
	void startCooking();
	void stopCooking();
	void uploadRecipe(byte mode, word temperature, word duration);
	
};

extern HomeChef_Class HomeChef;

#endif