/*
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>. 
*/

const byte PIN_ENC_A = 5;
const byte PIN_ENC_B = 13;
const byte PIN_ENC_X = A3;
const byte PIN_BTN_A = A0;
const byte PIN_BTN_B = A1;
const byte PIN_BTN_C = A2;
const byte PIN_LED_A = A4;
const byte PIN_LED_B = A5;
//const byte PIN_LED_C = RXLED;

void setup() {
  pinMode(PIN_ENC_A, INPUT);
  pinMode(PIN_ENC_B, INPUT);  
  pinMode(PIN_ENC_X, INPUT);
  pinMode(PIN_BTN_A, INPUT);  
  pinMode(PIN_BTN_B, INPUT);  
  pinMode(PIN_BTN_C, INPUT);  
  pinMode(PIN_LED_A, OUTPUT);  
  pinMode(PIN_LED_B, OUTPUT);  
//  pinMode(PIN_LED_C, OUTPUT);  
}

char encoderDelta() {
  static char last_state = 0;
  char state = (digitalRead(PIN_ENC_A)) << 1 | digitalRead(PIN_ENC_B);
  state = state ^ (state >> 1);
  char delta = state - last_state;
  last_state = state;
  return delta;
}

void loop() {
//  boolean a = digitalRead(PIN_ENC_A);
//  boolean b = digitalRead(PIN_ENC_A);  
   byte x = 0;
//  x += encoderDelta();
  if(!digitalRead(PIN_BTN_A)) x = 1;
  if(!digitalRead(PIN_BTN_B)) x = 2;
  if(!digitalRead(PIN_BTN_C)) x = 3;
  
  digitalWrite(PIN_LED_A, !(x & 1));
  digitalWrite(PIN_LED_B, !(x & 2));  
//  digitalWrite(PIN_LED_C, x & 4);  
//  x++;
//  delay(250);
}
