/*
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>. 
*/

#include <SandS.h>
#include <Wire.h>
#include <EEPROM.h>
#include <HomeChef.h>

void setup() {
  HomeChef.begin();
  Serial.begin(115200);
}

void loop() {
  if(!HomeChef.readStatus()) {
    Serial.println("\n== STATUS READOUT FAILED =======");
  } else {
    Serial.println("\n== OVEN STATUS READOUT =========");
    Serial.print("Oven light status:      ");
    Serial.println(HomeChef.ovenLightStatus);
    Serial.print("Applicance state:       ");
    Serial.println(HomeChef.applicanceState);
    Serial.print("Recipe name:            ");
    Serial.println(HomeChef.recipeName);
    Serial.print("Oven temperature:       ");
    Serial.println(HomeChef.ovenTemperature);
    Serial.print("Minutes elapsed:        ");
    Serial.println(HomeChef.minutesElapsed);
    Serial.print("Minutes remaining:      ");
    Serial.println(HomeChef.minutesRemaining);
    Serial.print("Temperature setpoint:   ");
    Serial.println(HomeChef.temperatureSetpoint);
    Serial.print("Active heater system:   ");
    Serial.println(HomeChef.activeHeaterSystem);
    Serial.print("Meat probe temperature: ");
    Serial.println(HomeChef.meatProbeTemperature);
    Serial.print("Child lock status:      ");
    Serial.println(HomeChef.childLockStatus);
  }
  if(Serial.available()) {
    switch(Serial.read()) {
      case 'B':
        HomeChef.startCooking();
        break;
      case 'E':
        HomeChef.stopCooking();
        break;
      case 'U':
        HomeChef.uploadRecipe(UPPER_INFRA_FAN, 120, 60);
        break;
      case 'L':
        HomeChef.setOvenLight(!HomeChef.ovenLightStatus);
        break;
      case 'C':
        HomeChef.setChildLock(!HomeChef.childLockStatus);
        break;
    }
  }
}
