/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.ajaxstatus;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.ajaxstatus.AjaxStatus;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class AjaxStatusRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AjaxStatus status = (AjaxStatus)component;
        this.encodeMarkup(context, status);
        this.encodeScript(context, status);
    }

    protected void encodeScript(FacesContext context, AjaxStatus status) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = status.getClientId(context);
        String widgetVar = status.resolveWidgetVar();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("AjaxStatus", widgetVar, clientId, false);
        this.startScript(writer, clientId);
        writer.write(wb.build());
        this.encodeCallback(context, status, widgetVar, "ajaxSend", "onprestart", "prestart");
        this.encodeCallback(context, status, widgetVar, "ajaxStart", "onstart", "start");
        this.encodeCallback(context, status, widgetVar, "ajaxError", "onerror", "error");
        this.encodeCallback(context, status, widgetVar, "ajaxSuccess", "onsuccess", "success");
        this.encodeCallback(context, status, widgetVar, "ajaxComplete", "oncomplete", "complete");
        this.endScript(writer);
    }

    protected void encodeCallback(FacesContext context, AjaxStatus status, String var, String event, String callback, String facetName) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String fn = (String)status.getAttributes().get(callback);
        if (fn != null) {
            writer.write(var + ".bindCallback('" + event + "',function(){" + fn + "});");
        } else if (status.getFacet(facetName) != null) {
            writer.write(var + ".bindFacet('" + event + "', '" + facetName + "');");
        }
    }

    protected void encodeMarkup(FacesContext context, AjaxStatus status) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = status.getClientId(context);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (status.getStyle() != null) {
            writer.writeAttribute("style", (Object)status.getStyle(), "style");
        }
        if (status.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)status.getStyleClass(), "styleClass");
        }
        for (String facetName : AjaxStatus.FACETS) {
            UIComponent facet = status.getFacet(facetName);
            if (facet == null) continue;
            this.encodeFacet(context, clientId, facet, facetName, true);
        }
        UIComponent defaultFacet = status.getFacet("default");
        if (defaultFacet != null) {
            this.encodeFacet(context, clientId, defaultFacet, "default", false);
        }
        writer.endElement("div");
    }

    protected void encodeFacet(FacesContext facesContext, String clientId, UIComponent facet, String facetName, boolean hidden) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_" + facetName), null);
        if (hidden) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        this.renderChild(facesContext, facet);
        writer.endElement("div");
    }
}

