/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.commandbutton;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.commandbutton.CommandButton;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class CommandButtonRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        CommandButton button = (CommandButton)component;
        if (button.isDisabled()) {
            return;
        }
        String param = component.getClientId(context);
        if (context.getExternalContext().getRequestParameterMap().containsKey(param)) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        CommandButton button = (CommandButton)component;
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    protected void encodeMarkup(FacesContext context, CommandButton button) throws IOException {
        String onclickBehaviors;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        String type = button.getType();
        Object value = button.getValue();
        String icon = button.resolveIcon();
        StringBuilder onclick = new StringBuilder();
        if (button.getOnclick() != null) {
            onclick.append(button.getOnclick()).append(";");
        }
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("class", (Object)button.resolveStyleClass(), "styleClass");
        if (!type.equals("reset") && !type.equals("button")) {
            String request;
            if (button.isAjax()) {
                request = this.buildAjaxRequest(context, button, null);
            } else {
                UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)button);
                if (form == null) {
                    throw new FacesException("CommandButton : \"" + clientId + "\" must be inside a form element");
                }
                request = this.buildNonAjaxRequest(context, (UIComponent)button, form, null, false);
            }
            onclick.append(request);
        }
        if ((onclickBehaviors = this.getOnclickBehaviors(context, (ClientBehaviorHolder)button)) != null) {
            onclick.append(onclickBehaviors).append(";");
        }
        if (onclick.length() > 0) {
            writer.writeAttribute("onclick", (Object)onclick.toString(), "onclick");
        }
        this.renderPassThruAttributes(context, (UIComponent)button, HTML.BUTTON_ATTRS, HTML.CLICK_EVENT);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (button.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if (icon != null) {
            String defaultIconClass = button.getIconPos().equals("left") ? "ui-button-icon-left ui-icon ui-c" : "ui-button-icon-right ui-icon ui-c";
            String iconClass = defaultIconClass + " " + icon;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconClass, null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        if (value == null) {
            writer.write("ui-button");
        } else if (button.isEscape()) {
            writer.writeText(value, "value");
        } else {
            writer.write(value.toString());
        }
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeScript(FacesContext context, CommandButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("CommandButton", button.resolveWidgetVar(), clientId, false);
        this.startScript(writer, clientId);
        writer.write(wb.build());
        this.endScript(writer);
    }
}

