/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.contextmenu;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.Widget;
import org.primefaces.component.contextmenu.ContextMenu;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.tieredmenu.TieredMenuRenderer;
import org.primefaces.util.WidgetBuilder;

public class ContextMenuRenderer
extends TieredMenuRenderer {
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ContextMenu menu = (ContextMenu)abstractMenu;
        String clientId = menu.getClientId(context);
        UIComponent target = this.findTarget(context, menu);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("ContextMenu", menu.resolveWidgetVar(), clientId, true);
        if (target != null) {
            wb.attr("target", target.getClientId(context)).attr("type", target.getClass().getSimpleName());
            if (target instanceof Widget) {
                wb.attr("targetWidgetVar", ((Widget)target).resolveWidgetVar());
            }
        }
        wb.attr("nodeType", menu.getNodeType(), null).attr("event", menu.getEvent(), null).callback("beforeShow", "function()", menu.getBeforeShow());
        this.startScript(writer, clientId);
        writer.write(wb.build());
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ContextMenu menu = (ContextMenu)abstractMenu;
        String style = menu.getStyle();
        String styleClass = menu.getStyleClass();
        styleClass = styleClass == null ? "ui-menu ui-menu-dynamic ui-contextmenu ui-widget ui-widget-content ui-corner-all ui-helper-clearfix ui-shadow" : "ui-menu ui-menu-dynamic ui-contextmenu ui-widget ui-widget-content ui-corner-all ui-helper-clearfix ui-shadow " + styleClass;
        this.encodeMenu(context, menu, style, styleClass, "menu");
    }

    protected UIComponent findTarget(FacesContext context, ContextMenu menu) {
        String _for = menu.getFor();
        if (_for != null) {
            UIComponent forComponent = menu.findComponent(_for);
            if (forComponent == null) {
                throw new FacesException("Cannot find component '" + _for + "' in view.");
            }
            return forComponent;
        }
        return null;
    }
}

