/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;

public class RowEditFeature
implements DataTableFeature {
    public void decode(FacesContext context, DataTable table) {
        throw new RuntimeException("RowEditFeature should not encode.");
    }

    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = table.getClientId(context);
        int editedRowId = Integer.parseInt((String)params.get(table.getClientId(context) + "_rowEditIndex"));
        String action = (String)params.get(table.getClientId(context) + "_rowEditAction");
        table.setRowIndex(editedRowId);
        if (action.equals("cancel")) {
            for (UIColumn column : table.getColumns()) {
                for (UIComponent grandkid : column.getChildren()) {
                    UIComponent inputFacet;
                    if (!(grandkid instanceof CellEditor) || !((inputFacet = grandkid.getFacet("input")) instanceof EditableValueHolder)) continue;
                    ((EditableValueHolder)inputFacet).resetValue();
                }
            }
        }
        if (table.isRowAvailable()) {
            renderer.encodeRow(context, table, table.getClientId(context), editedRowId, table.getRowIndexVar());
        }
    }

    public boolean shouldDecode(FacesContext context, DataTable table) {
        return false;
    }

    public boolean shouldEncode(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_rowEditAction");
    }
}

