/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.growl;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.growl.Growl;
import org.primefaces.renderkit.UINotificationRenderer;

public class GrowlRenderer
extends UINotificationRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Growl growl = (Growl)component;
        String clientId = growl.getClientId(context);
        String widgetVar = growl.resolveWidgetVar();
        writer.startElement("span", (UIComponent)growl);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.endElement("span");
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('Growl','" + widgetVar + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",sticky:" + growl.isSticky());
        writer.write(",life:" + growl.getLife());
        writer.write(",escape:" + growl.isEscape());
        writer.write(",msgs:");
        this.encodeMessages(context, growl);
        writer.write("});});");
        this.endScript(writer);
    }

    protected void encodeMessages(FacesContext context, Growl growl) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String _for = growl.getFor();
        Iterator messages = _for != null ? context.getMessages(_for) : (growl.isGlobalOnly() ? context.getMessages(null) : context.getMessages());
        writer.write("[");
        while (messages.hasNext()) {
            String severityName;
            FacesMessage message = (FacesMessage)messages.next();
            if (!this.shouldRender(growl, message, severityName = this.getSeverityName(message))) continue;
            String summary = this.escapeText(message.getSummary());
            String detail = this.escapeText(message.getDetail());
            writer.write("{");
            if (growl.isShowSummary() && growl.isShowDetail()) {
                writer.writeText((Object)("summary:\"" + summary + "\",detail:\"" + detail + "\""), null);
            } else if (growl.isShowSummary() && !growl.isShowDetail()) {
                writer.writeText((Object)("summary:\"" + summary + "\",detail:\"\""), null);
            } else if (!growl.isShowSummary() && growl.isShowDetail()) {
                writer.writeText((Object)("summary:\"\",detail:\"" + detail + "\""), null);
            }
            writer.write(",severity:'" + severityName + "'");
            writer.write("}");
            if (messages.hasNext()) {
                writer.write(",");
            }
            message.rendered();
        }
        writer.write("]");
    }
}

