/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputtext;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.inputtext.InputText;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class InputTextRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        InputText inputText = (InputText)component;
        if (inputText.isDisabled() || inputText.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputText);
        String clientId = inputText.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (submittedValue != null) {
            inputText.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputText inputText = (InputText)component;
        this.encodeMarkup(context, inputText);
        this.encodeScript(context, inputText);
    }

    protected void encodeScript(FacesContext context, InputText inputText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputText.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("InputText", inputText.resolveWidgetVar(), clientId, false);
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)inputText, wb);
        this.startScript(writer, clientId);
        writer.write(wb.build());
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, InputText inputText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputText.getClientId(context);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)inputText.getType(), null);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)inputText);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderPassThruAttributes(context, (UIComponent)inputText, HTML.INPUT_TEXT_ATTRS);
        if (inputText.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (inputText.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (inputText.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputText.getStyle(), null);
        }
        writer.writeAttribute("class", (Object)this.createStyleClass(inputText), "styleClass");
        writer.endElement("input");
    }

    protected String createStyleClass(InputText inputText) {
        String defaultClass = "ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
        defaultClass = inputText.isValid() ? defaultClass : defaultClass + " ui-state-error";
        defaultClass = !inputText.isDisabled() ? defaultClass : defaultClass + " ui-state-disabled";
        String styleClass = inputText.getStyleClass();
        styleClass = styleClass == null ? defaultClass : defaultClass + " " + styleClass;
        return styleClass;
    }
}

