/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.util.Comparator;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.primefaces.model.SortOrder;

public class BeanPropertyComparator
implements Comparator {
    private ValueExpression sortBy;
    private boolean asc;
    private String var;
    private MethodExpression sortFunction;
    private static final Logger logger = Logger.getLogger(BeanPropertyComparator.class.getName());

    public BeanPropertyComparator(ValueExpression sortBy, String var, SortOrder sortOrder, MethodExpression sortFunction) {
        this.sortBy = sortBy;
        this.var = var;
        this.asc = sortOrder.equals((Object)SortOrder.ASCENDING);
        this.sortFunction = sortFunction;
    }

    public int compare(Object obj1, Object obj2) {
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            context.getExternalContext().getRequestMap().put(this.var, obj1);
            Object value1 = this.sortBy.getValue(context.getELContext());
            context.getExternalContext().getRequestMap().put(this.var, obj2);
            Object value2 = this.sortBy.getValue(context.getELContext());
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null) {
                return 1;
            }
            if (value2 == null) {
                return -1;
            }
            int result = this.sortFunction == null ? ((Comparable)value1).compareTo(value2) : ((Integer)this.sortFunction.invoke(context.getELContext(), new Object[]{value1, value2})).intValue();
            return this.asc ? result : -1 * result;
        }
        catch (Exception e) {
            logger.severe("Error in sorting");
            throw new RuntimeException(e);
        }
    }
}

