/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.push;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.servlet.ServletInputStream;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.MetaBroadcaster;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.primefaces.push.PushRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimeAtmosphereHandler
extends AbstractReflectorAtmosphereHandler {
    private final List<PushRule> rules;

    public PrimeAtmosphereHandler(List<PushRule> rules) {
        this.rules = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequest(AtmosphereResource resource) throws IOException {
        AtmosphereRequest r = resource.getRequest();
        if (r.getMethod().equalsIgnoreCase("GET")) {
            this.applyRules(resource);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                ServletInputStream inputStream = r.getRequest().getInputStream();
                if (inputStream != null) {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                    char[] charBuffer = new char[8192];
                    int bytesRead = -1;
                    while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                        stringBuilder.append(charBuffer, 0, bytesRead);
                    }
                } else {
                    stringBuilder.append("");
                }
            }
            catch (IOException ex) {
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException ex) {}
                }
            }
            MetaBroadcaster.getDefault().broadcastTo("/*", (Object)stringBuilder.toString());
        }
    }

    protected void applyRules(AtmosphereResource resource) {
        for (PushRule r : this.rules) {
            boolean ok = r.apply(resource);
            if (ok) continue;
            return;
        }
    }

    public void destroy() {
    }
}

