/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.push;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsyncSupportListener;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.primefaces.push.DefaultPushRule;
import org.primefaces.push.PrimeAtmosphereHandler;
import org.primefaces.push.PushContext;
import org.primefaces.push.PushContextFactory;
import org.primefaces.push.PushContextImpl;
import org.primefaces.push.PushRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushServlet
extends AtmosphereServlet {
    private final Logger logger = Logger.getLogger(PushServlet.class.getName());
    public static final String RULES = "org.primefaces.push.rules";

    public void init(ServletConfig sc) throws ServletException {
        this.framework().addInitParameter(ApplicationConfig.BROADCASTER_SHARABLE_THREAD_POOLS, "true");
        PushContext c = PushContextFactory.getDefault().getPushContext();
        if (PushContextImpl.class.isAssignableFrom(c.getClass())) {
            this.framework().asyncSupportListener((AsyncSupportListener)PushContextImpl.class.cast(c));
        }
        super.init(sc);
        this.framework.interceptor((AtmosphereInterceptor)new AtmosphereResourceLifecycleInterceptor()).addAtmosphereHandler("/*", (AtmosphereHandler)new PrimeAtmosphereHandler(this.configureRules(sc))).initAtmosphereHandler(sc);
    }

    List<PushRule> configureRules(ServletConfig sc) {
        ArrayList<PushRule> rules = new ArrayList<PushRule>();
        String s = sc.getInitParameter(RULES);
        if (s != null) {
            String[] r;
            for (String rule : r = s.split(",")) {
                try {
                    rules.add(this.loadRule(rule));
                    this.logger.log(Level.INFO, "PushRule " + rule + " loaded");
                }
                catch (Throwable t) {
                    this.logger.log(Level.WARNING, "Unable to load PushRule " + rule, t);
                }
            }
        }
        if (rules.isEmpty()) {
            rules.add(new DefaultPushRule());
        }
        return rules;
    }

    PushRule loadRule(String ruleName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        try {
            return (PushRule)Thread.currentThread().getContextClassLoader().loadClass(ruleName).newInstance();
        }
        catch (Throwable t) {
            return (PushRule)((Object)((Object)this)).getClass().getClassLoader().loadClass(ruleName).newInstance();
        }
    }
}

