/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.ValueHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.validator.BeanValidator;
import org.primefaces.component.api.RTLAware;
import org.primefaces.component.api.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentUtils {
    public static String getValueToRender(FacesContext context, UIComponent component) {
        if (component instanceof ValueHolder) {
            ValueHolder valueHolder;
            Object value;
            if (component instanceof EditableValueHolder) {
                EditableValueHolder input = (EditableValueHolder)component;
                Object submittedValue = input.getSubmittedValue();
                if (ComponentUtils.considerEmptyStringAsNull(context) && submittedValue == null && context.isValidationFailed() && !input.isValid()) {
                    return null;
                }
                if (submittedValue != null) {
                    return submittedValue.toString();
                }
            }
            if ((value = (valueHolder = (ValueHolder)component).getValue()) != null) {
                Converter converter = ComponentUtils.getConverter(context, valueHolder);
                if (converter != null) {
                    return converter.getAsString(context, component, value);
                }
                return value.toString();
            }
            return null;
        }
        return null;
    }

    public static Converter getConverter(FacesContext context, ValueHolder component) {
        Class valueType;
        ValueExpression expr;
        Converter converter = component.getConverter();
        if (converter == null && (expr = ((UIComponent)component).getValueExpression("value")) != null && (valueType = expr.getType(context.getELContext())) != null) {
            converter = context.getApplication().createConverter(valueType);
        }
        return converter;
    }

    public static UIComponent findParentForm(FacesContext context, UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIForm)) continue;
            return parent;
        }
        return null;
    }

    public static UniqueIdVendor findParentUniqueIdVendor(UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UniqueIdVendor)) continue;
            return (UniqueIdVendor)parent;
        }
        return null;
    }

    public static UIComponent findParentNamingContainer(UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof NamingContainer)) continue;
            return parent;
        }
        return null;
    }

    public static void decorateAttribute(UIComponent component, String attribute, String value) {
        String attributeValue = (String)component.getAttributes().get(attribute);
        if (attributeValue != null) {
            if (attributeValue.indexOf(value) == -1) {
                String decoratedValue = attributeValue + ";" + value;
                component.getAttributes().put(attribute, decoratedValue);
            } else {
                component.getAttributes().put(attribute, attributeValue);
            }
        } else {
            component.getAttributes().put(attribute, value);
        }
    }

    public static List<SelectItem> createSelectItems(UIComponent component) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UISelectItem) {
                UISelectItem selectItem = (UISelectItem)child;
                items.add(new SelectItem(selectItem.getItemValue(), selectItem.getItemLabel()));
                continue;
            }
            if (!(child instanceof UISelectItems)) continue;
            Object selectItems = ((UISelectItems)child).getValue();
            if (selectItems instanceof SelectItem[]) {
                SelectItem[] itemsArray;
                for (SelectItem item : itemsArray = (SelectItem[])selectItems) {
                    items.add(new SelectItem(item.getValue(), item.getLabel()));
                }
                continue;
            }
            if (!(selectItems instanceof Collection)) continue;
            Collection collection = (Collection)selectItems;
            for (SelectItem item : collection) {
                items.add(new SelectItem(item.getValue(), item.getLabel()));
            }
        }
        return items;
    }

    public static String escapeJQueryId(String id) {
        return "#" + id.replaceAll(":", "\\\\\\\\:");
    }

    public static String findClientIds(FacesContext context, UIComponent component, String list) {
        if (list == null) {
            return "@none";
        }
        String[] ids = list.split("[,\\s]+");
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            String id;
            if (i != 0) {
                buffer.append(" ");
            }
            if ((id = ids[i].trim()).equals("@all") || id.equals("@none")) {
                buffer.append(id);
                continue;
            }
            if (id.equals("@this")) {
                buffer.append(component.getClientId(context));
                continue;
            }
            if (id.equals("@form")) {
                UIComponent form = ComponentUtils.findParentForm(context, component);
                if (form == null) {
                    throw new FacesException("Component " + component.getClientId(context) + " needs to be enclosed in a form");
                }
                buffer.append(form.getClientId(context));
                continue;
            }
            if (id.equals("@parent")) {
                buffer.append(component.getParent().getClientId(context));
                continue;
            }
            if (id.equals("@namingcontainer")) {
                UIComponent container = ComponentUtils.findParentNamingContainer(component);
                if (container == null) continue;
                buffer.append(container.getClientId(context));
                continue;
            }
            UIComponent comp = component.findComponent(id);
            if (comp != null) {
                buffer.append(comp.getClientId(context));
                continue;
            }
            throw new FacesException("Cannot find component with identifier \"" + id + "\" referenced from \"" + component.getClientId(context) + "\".");
        }
        return buffer.toString();
    }

    public static String findComponentClientId(String id) {
        UIComponent component = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        component = ComponentUtils.findComponent((UIComponent)facesContext.getViewRoot(), id);
        return component.getClientId(facesContext);
    }

    public static UIComponent findComponent(UIComponent base, String id) {
        if (id.equals(base.getId())) {
            return base;
        }
        UIComponent kid = null;
        UIComponent result = null;
        Iterator kids = base.getFacetsAndChildren();
        while (kids.hasNext() && result == null) {
            kid = (UIComponent)kids.next();
            if (id.equals(kid.getId())) {
                result = kid;
                break;
            }
            result = ComponentUtils.findComponent(kid, id);
            if (result == null) continue;
            break;
        }
        return result;
    }

    public static String getWidgetVar(String id) {
        UIComponent component = ComponentUtils.findComponent((UIComponent)FacesContext.getCurrentInstance().getViewRoot(), id);
        if (component == null) {
            throw new FacesException("Cannot find component " + id + " in view.");
        }
        if (component instanceof Widget) {
            return ((Widget)component).resolveWidgetVar();
        }
        throw new FacesException("Component with id " + id + " is not a Widget");
    }

    public static boolean isLiteralText(UIComponent component) {
        return component.getFamily().equalsIgnoreCase("facelets.LiteralText");
    }

    public static Locale toLocale(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len != 2 && len != 5 && len < 7) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        char ch0 = str.charAt(0);
        char ch1 = str.charAt(1);
        if (ch0 < 'a' || ch0 > 'z' || ch1 < 'a' || ch1 > 'z') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        if (len == 2) {
            return new Locale(str, "");
        }
        if (str.charAt(2) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        char ch3 = str.charAt(3);
        if (ch3 == '_') {
            return new Locale(str.substring(0, 2), "", str.substring(4));
        }
        char ch4 = str.charAt(4);
        if (ch3 < 'A' || ch3 > 'Z' || ch4 < 'A' || ch4 > 'Z') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        if (len == 5) {
            return new Locale(str.substring(0, 2), str.substring(3, 5));
        }
        if (str.charAt(5) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        return new Locale(str.substring(0, 2), str.substring(3, 5), str.substring(6));
    }

    public static boolean validateEmptyFields(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String value = externalContext.getInitParameter("javax.faces.VALIDATE_EMPTY_FIELDS");
        if (null == value) {
            value = (String)externalContext.getApplicationMap().get("javax.faces.VALIDATE_EMPTY_FIELDS");
        }
        if (value == null || value.equals("auto")) {
            return ComponentUtils.isBeansValidationAvailable(context);
        }
        return Boolean.valueOf(value);
    }

    public static boolean isBeansValidationAvailable(FacesContext context) {
        boolean result = false;
        String beanValidationAvailableKey = "javax.faces.private.BEANS_VALIDATION_AVAILABLE";
        Map appMap = context.getExternalContext().getApplicationMap();
        if (appMap.containsKey(beanValidationAvailableKey)) {
            result = (Boolean)appMap.get(beanValidationAvailableKey);
        } else {
            try {
                new BeanValidator();
                result = true;
                appMap.put(beanValidationAvailableKey, true);
            }
            catch (Throwable t) {
                appMap.put(beanValidationAvailableKey, Boolean.FALSE);
            }
        }
        return result;
    }

    public static boolean isPartialSubmitEnabled(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String value = externalContext.getInitParameter("primefaces.SUBMIT");
        return value == null ? false : value.equalsIgnoreCase("partial");
    }

    public static boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    public static boolean isRTL(FacesContext context, RTLAware component) {
        ExternalContext externalContext = context.getExternalContext();
        String value = externalContext.getInitParameter("primefaces.DIR");
        boolean globalValue = value == null ? false : value.equalsIgnoreCase("rtl");
        return globalValue || component.isRTL();
    }

    public static boolean considerEmptyStringAsNull(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String value = externalContext.getInitParameter("javax.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL");
        return value == null ? false : Boolean.valueOf(value);
    }
}

