/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.model.DataModel;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.RTLAware;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UIData;
import org.primefaces.component.api.Widget;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.DataTableFeatureKey;
import org.primefaces.component.datatable.feature.DraggableColumnsFeature;
import org.primefaces.component.datatable.feature.FilterFeature;
import org.primefaces.component.datatable.feature.PageFeature;
import org.primefaces.component.datatable.feature.ResizableColumnsFeature;
import org.primefaces.component.datatable.feature.RowEditFeature;
import org.primefaces.component.datatable.feature.RowExpandFeature;
import org.primefaces.component.datatable.feature.ScrollFeature;
import org.primefaces.component.datatable.feature.SelectionFeature;
import org.primefaces.component.datatable.feature.SortFeature;
import org.primefaces.component.rowexpansion.RowExpansion;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.component.summaryrow.SummaryRow;
import org.primefaces.context.RequestContext;
import org.primefaces.event.CellEditEvent;
import org.primefaces.event.ColumnResizeEvent;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.ToggleEvent;
import org.primefaces.event.ToggleSelectEvent;
import org.primefaces.event.UnselectEvent;
import org.primefaces.event.data.FilterEvent;
import org.primefaces.event.data.PageEvent;
import org.primefaces.event.data.SortEvent;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SelectableDataModel;
import org.primefaces.model.SelectableDataModelWrapper;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.model.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="primefaces.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="primefaces.js")})
public class DataTable
extends UIData
implements Widget,
RTLAware,
ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DataTable";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.DataTableRenderer";
    private static final String OPTIMIZED_PACKAGE = "org.primefaces.component.";
    private static final Logger logger = Logger.getLogger(DataTable.class.getName());
    public static final String CONTAINER_CLASS = "ui-datatable ui-widget";
    public static final String TABLE_WRAPPER_CLASS = "ui-datatable-tablewrapper";
    public static final String RTL_CLASS = "ui-datatable-rtl";
    public static final String COLUMN_HEADER_CLASS = "ui-state-default";
    public static final String DYNAMIC_COLUMN_HEADER_CLASS = "ui-dynamic-column";
    public static final String COLUMN_HEADER_CONTAINER_CLASS = "ui-header-column";
    public static final String COLUMN_FOOTER_CLASS = "ui-state-default";
    public static final String COLUMN_FOOTER_CONTAINER_CLASS = "ui-footer-column";
    public static final String DATA_CLASS = "ui-datatable-data ui-widget-content";
    public static final String ROW_CLASS = "ui-widget-content";
    public static final String EMPTY_MESSAGE_ROW_CLASS = "ui-widget-content ui-datatable-empty-message";
    public static final String HEADER_CLASS = "ui-datatable-header ui-widget-header ui-corner-top";
    public static final String FOOTER_CLASS = "ui-datatable-footer ui-widget-header ui-corner-bottom";
    public static final String SORTABLE_COLUMN_CLASS = "ui-sortable-column";
    public static final String SORTABLE_COLUMN_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
    public static final String SORTABLE_COLUMN_ASCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
    public static final String SORTABLE_COLUMN_DESCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
    public static final String FILTER_COLUMN_CLASS = "ui-filter-column";
    public static final String COLUMN_FILTER_CLASS = "ui-column-filter ui-widget ui-state-default ui-corner-left";
    public static final String COLUMN_INPUT_FILTER_CLASS = "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
    public static final String RESIZABLE_COLUMN_CLASS = "ui-resizable-column";
    public static final String EXPANDED_ROW_CLASS = "ui-expanded-row";
    public static final String EXPANDED_ROW_CONTENT_CLASS = "ui-expanded-row-content";
    public static final String ROW_TOGGLER_CLASS = "ui-row-toggler";
    public static final String EDITABLE_COLUMN_CLASS = "ui-editable-column";
    public static final String CELL_EDITOR_CLASS = "ui-cell-editor";
    public static final String CELL_EDITOR_INPUT_CLASS = "ui-cell-editor-input";
    public static final String CELL_EDITOR_OUTPUT_CLASS = "ui-cell-editor-output";
    public static final String ROW_EDITOR_COLUMN_CLASS = "ui-row-editor-column";
    public static final String ROW_EDITOR_CLASS = "ui-row-editor";
    public static final String SELECTION_COLUMN_CLASS = "ui-selection-column";
    public static final String EVEN_ROW_CLASS = "ui-datatable-even";
    public static final String ODD_ROW_CLASS = "ui-datatable-odd";
    public static final String SCROLLABLE_CONTAINER_CLASS = "ui-datatable-scrollable";
    public static final String SCROLLABLE_HEADER_CLASS = "ui-widget-header ui-datatable-scrollable-header";
    public static final String SCROLLABLE_HEADER_BOX_CLASS = "ui-datatable-scrollable-header-box";
    public static final String SCROLLABLE_BODY_CLASS = "ui-datatable-scrollable-body";
    public static final String SCROLLABLE_FOOTER_CLASS = "ui-widget-header ui-datatable-scrollable-footer";
    public static final String SCROLLABLE_FOOTER_BOX_CLASS = "ui-datatable-scrollable-footer-box";
    public static final String COLUMN_RESIZER_CLASS = "ui-column-resizer";
    public static final String RESIZABLE_CONTAINER_CLASS = "ui-datatable-resizable";
    public static final String SUBTABLE_HEADER = "ui-datatable-subtable-header";
    public static final String SUBTABLE_FOOTER = "ui-datatable-subtable-footer";
    public static final String SUMMARY_ROW_CLASS = "ui-datatable-summaryrow ui-widget-header";
    public static final String EDITING_ROW_CLASS = "ui-row-editing";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("page", "sort", "filter", "rowSelect", "rowUnselect", "rowEdit", "rowEditInit", "rowEditCancel", "colResize", "toggleSelect", "colReorder", "contextMenu", "rowSelectRadio", "rowSelectCheckbox", "rowUnselectCheckbox", "rowDblselect", "rowToggle", "cellEdit"));
    static Map<DataTableFeatureKey, DataTableFeature> FEATURES = new HashMap<DataTableFeatureKey, DataTableFeature>();
    private boolean reset = false;
    private SelectableDataModelWrapper selectableDataModelWrapper = null;
    private List<Object> selectedRowKeys = new ArrayList<Object>();
    private int columnsCount = -1;
    private List<UIColumn> columns;
    private UIColumn sortColumn;
    private List<SortMeta> multiSortMeta;

    public DataTable() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
        this.handleAttribute("widgetVar", _widgetVar);
    }

    public boolean isScrollable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollable), (Object)false);
    }

    public void setScrollable(boolean _scrollable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollable), (Object)_scrollable);
        this.handleAttribute("scrollable", _scrollable);
    }

    public String getScrollHeight() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollHeight), null);
    }

    public void setScrollHeight(String _scrollHeight) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollHeight), (Object)_scrollHeight);
        this.handleAttribute("scrollHeight", _scrollHeight);
    }

    public String getScrollWidth() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollWidth), null);
    }

    public void setScrollWidth(String _scrollWidth) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollWidth), (Object)_scrollWidth);
        this.handleAttribute("scrollWidth", _scrollWidth);
    }

    public String getSelectionMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectionMode), null);
    }

    public void setSelectionMode(String _selectionMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectionMode), (Object)_selectionMode);
        this.handleAttribute("selectionMode", _selectionMode);
    }

    public Object getSelection() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selection), null);
    }

    public void setSelection(Object _selection) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selection), _selection);
        this.handleAttribute("selection", _selection);
    }

    public String getEmptyMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.emptyMessage), (Object)"No records found.");
    }

    public void setEmptyMessage(String _emptyMessage) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.emptyMessage), (Object)_emptyMessage);
        this.handleAttribute("emptyMessage", _emptyMessage);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
        this.handleAttribute("style", _style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
        this.handleAttribute("styleClass", _styleClass);
    }

    public boolean isLiveScroll() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.liveScroll), (Object)false);
    }

    public void setLiveScroll(boolean _liveScroll) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.liveScroll), (Object)_liveScroll);
        this.handleAttribute("liveScroll", _liveScroll);
    }

    public String getRowStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowStyleClass), null);
    }

    public void setRowStyleClass(String _rowStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowStyleClass), (Object)_rowStyleClass);
        this.handleAttribute("rowStyleClass", _rowStyleClass);
    }

    public String getOnExpandStart() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onExpandStart), null);
    }

    public void setOnExpandStart(String _onExpandStart) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onExpandStart), (Object)_onExpandStart);
        this.handleAttribute("onExpandStart", _onExpandStart);
    }

    public boolean isResizableColumns() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizableColumns), (Object)false);
    }

    public void setResizableColumns(boolean _resizableColumns) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizableColumns), (Object)_resizableColumns);
        this.handleAttribute("resizableColumns", _resizableColumns);
    }

    public Object getSortBy() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortBy), null);
    }

    public void setSortBy(Object _sortBy) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortBy), _sortBy);
        this.handleAttribute("sortBy", _sortBy);
    }

    public String getSortOrder() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortOrder), (Object)"ascending");
    }

    public void setSortOrder(String _sortOrder) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortOrder), (Object)_sortOrder);
        this.handleAttribute("sortOrder", _sortOrder);
    }

    public MethodExpression getSortFunction() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortFunction), null);
    }

    public void setSortFunction(MethodExpression _sortFunction) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortFunction), (Object)_sortFunction);
        this.handleAttribute("sortFunction", _sortFunction);
    }

    public int getScrollRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollRows), (Object)0);
    }

    public void setScrollRows(int _scrollRows) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollRows), (Object)_scrollRows);
        this.handleAttribute("scrollRows", _scrollRows);
    }

    public Object getRowKey() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowKey), null);
    }

    public void setRowKey(Object _rowKey) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowKey), _rowKey);
        this.handleAttribute("rowKey", _rowKey);
    }

    public String getFilterEvent() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filterEvent), null);
    }

    public void setFilterEvent(String _filterEvent) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterEvent), (Object)_filterEvent);
        this.handleAttribute("filterEvent", _filterEvent);
    }

    public int getFilterDelay() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filterDelay), (Object)Integer.MAX_VALUE);
    }

    public void setFilterDelay(int _filterDelay) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterDelay), (Object)_filterDelay);
        this.handleAttribute("filterDelay", _filterDelay);
    }

    public String getTableStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tableStyle), null);
    }

    public void setTableStyle(String _tableStyle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tableStyle), (Object)_tableStyle);
        this.handleAttribute("tableStyle", _tableStyle);
    }

    public String getTableStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tableStyleClass), null);
    }

    public void setTableStyleClass(String _tableStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tableStyleClass), (Object)_tableStyleClass);
        this.handleAttribute("tableStyleClass", _tableStyleClass);
    }

    public boolean isDraggableColumns() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.draggableColumns), (Object)false);
    }

    public void setDraggableColumns(boolean _draggableColumns) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.draggableColumns), (Object)_draggableColumns);
        this.handleAttribute("draggableColumns", _draggableColumns);
    }

    public boolean isEditable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editable), (Object)false);
    }

    public void setEditable(boolean _editable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editable), (Object)_editable);
        this.handleAttribute("editable", _editable);
    }

    public List getFilteredValue() {
        return (List)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filteredValue), null);
    }

    public void setFilteredValue(List _filteredValue) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filteredValue), (Object)_filteredValue);
        this.handleAttribute("filteredValue", _filteredValue);
    }

    public String getSortMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortMode), (Object)"single");
    }

    public void setSortMode(String _sortMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortMode), (Object)_sortMode);
        this.handleAttribute("sortMode", _sortMode);
    }

    public String getEditMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editMode), (Object)"row");
    }

    public void setEditMode(String _editMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editMode), (Object)_editMode);
        this.handleAttribute("editMode", _editMode);
    }

    public boolean isEditingRow() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editingRow), (Object)false);
    }

    public void setEditingRow(boolean _editingRow) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editingRow), (Object)_editingRow);
        this.handleAttribute("editingRow", _editingRow);
    }

    public String getCellSeparator() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.cellSeparator), null);
    }

    public void setCellSeparator(String _cellSeparator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.cellSeparator), (Object)_cellSeparator);
        this.handleAttribute("cellSeparator", _cellSeparator);
    }

    public String getSummary() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.summary), null);
    }

    public void setSummary(String _summary) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.summary), (Object)_summary);
        this.handleAttribute("summary", _summary);
    }

    public Collection getFrozenRows() {
        return (Collection)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.frozenRows), null);
    }

    public void setFrozenRows(Collection _frozenRows) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.frozenRows), (Object)_frozenRows);
        this.handleAttribute("frozenRows", _frozenRows);
    }

    public String getDir() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dir), (Object)"ltr");
    }

    public void setDir(String _dir) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dir), (Object)_dir);
        this.handleAttribute("dir", _dir);
    }

    public boolean isLiveResize() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.liveResize), (Object)false);
    }

    public void setLiveResize(boolean _liveResize) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.liveResize), (Object)_liveResize);
        this.handleAttribute("liveResize", _liveResize);
    }

    public boolean shouldEncodeFeature(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_encodeFeature");
    }

    public boolean isRowEditRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_rowEditAction");
    }

    public boolean isRowEditCancelRequest(FacesContext context) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String value = (String)params.get(this.getClientId(context) + "_rowEditAction");
        return value != null && value.equals("cancel");
    }

    public boolean isRowSelectionEnabled() {
        return this.getSelectionMode() != null;
    }

    public boolean isColumnSelectionEnabled() {
        return this.getColumnSelectionMode() != null;
    }

    public String getColumnSelectionMode() {
        for (UIComponent child : this.getChildren()) {
            String selectionMode;
            if (!child.isRendered() || !(child instanceof Column) || (selectionMode = ((Column)child).getSelectionMode()) == null) continue;
            return selectionMode;
        }
        return null;
    }

    public boolean isSelectionEnabled() {
        return this.isRowSelectionEnabled() || this.isColumnSelectionEnabled();
    }

    public boolean isSingleSelectionMode() {
        String selectionMode = this.getSelectionMode();
        String columnSelectionMode = this.getColumnSelectionMode();
        if (selectionMode != null) {
            return selectionMode.equalsIgnoreCase("single");
        }
        if (columnSelectionMode != null) {
            return columnSelectionMode.equalsIgnoreCase("single");
        }
        return false;
    }

    @Override
    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        ValueExpression selectionVE = this.getValueExpression("selection");
        if (selectionVE != null) {
            selectionVE.setValue(context.getELContext(), this.getLocalSelection());
            this.setSelection(null);
        }
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (this.isRequestSource(context) && event instanceof AjaxBehaviorEvent) {
            this.setRowIndex(-1);
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent wrapperEvent = null;
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals("rowSelect") || eventName.equals("rowSelectRadio") || eventName.equals("contextMenu") || eventName.equals("rowSelectCheckbox") || eventName.equals("rowDblselect")) {
                String rowKey = (String)params.get(clientId + "_instantSelectedRowKey");
                wrapperEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowKey));
            } else if (eventName.equals("rowUnselect") || eventName.equals("rowUnselectCheckbox")) {
                String rowKey = (String)params.get(clientId + "_instantUnselectedRowKey");
                wrapperEvent = new UnselectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowKey));
            } else if (eventName.equals("page")) {
                int rows = this.getRowsToRender();
                int first = Integer.parseInt((String)params.get(clientId + "_first"));
                int page = rows > 0 ? first / rows : 0;
                wrapperEvent = new PageEvent((UIComponent)this, behaviorEvent.getBehavior(), page);
            } else if (eventName.equals("sort")) {
                UIColumn sortColumn;
                SortOrder order;
                if (this.isMultiSort()) {
                    String[] sortDirs = ((String)params.get(clientId + "_sortDir")).split(",");
                    String[] sortKeys = ((String)params.get(clientId + "_sortKey")).split(",");
                    order = SortOrder.valueOf(sortDirs[sortDirs.length - 1]);
                    sortColumn = this.findColumn(sortKeys[sortKeys.length - 1]);
                } else {
                    order = SortOrder.valueOf((String)params.get(clientId + "_sortDir"));
                    sortColumn = this.findColumn((String)params.get(clientId + "_sortKey"));
                }
                wrapperEvent = new SortEvent((UIComponent)this, behaviorEvent.getBehavior(), sortColumn, order);
            } else if (eventName.equals("filter")) {
                wrapperEvent = new FilterEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getFilteredValue(), this.getFilters());
            } else if (eventName.equals("rowEdit") || eventName.equals("rowEditCancel") || eventName.equals("rowEditInit")) {
                int rowIndex = Integer.parseInt((String)params.get(clientId + "_rowEditIndex"));
                this.setRowIndex(rowIndex);
                wrapperEvent = new RowEditEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData());
            } else if (eventName.equals("colResize")) {
                String columnId = (String)params.get(clientId + "_columnId");
                int width = Integer.parseInt((String)params.get(clientId + "_width"));
                int height = Integer.parseInt((String)params.get(clientId + "_height"));
                wrapperEvent = new ColumnResizeEvent((UIComponent)this, behaviorEvent.getBehavior(), width, height, this.findColumn(columnId));
            } else if (eventName.equals("toggleSelect")) {
                boolean checked = Boolean.valueOf((String)params.get(clientId + "_checked"));
                wrapperEvent = new ToggleSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), checked);
            } else if (eventName.equals("colReorder")) {
                wrapperEvent = behaviorEvent;
            } else if (eventName.equals("rowToggle")) {
                boolean expansion = params.containsKey(clientId + "_rowExpansion");
                Visibility visibility = expansion ? Visibility.VISIBLE : Visibility.HIDDEN;
                String rowIndex = expansion ? (String)params.get(clientId + "_expandedRowIndex") : (String)params.get(clientId + "_collapsedRowIndex");
                this.setRowIndex(Integer.parseInt(rowIndex));
                wrapperEvent = new ToggleEvent((UIComponent)this, behaviorEvent.getBehavior(), visibility, this.getRowData());
            } else if (eventName.equals("cellEdit")) {
                String[] cellInfo = ((String)params.get(clientId + "_cellInfo")).split(",");
                int rowIndex = Integer.parseInt(cellInfo[0]);
                int cellIndex = Integer.parseInt(cellInfo[1]);
                int i = -1;
                UIColumn column = null;
                for (UIColumn col : this.getColumns()) {
                    if (!col.isRendered() || ++i != cellIndex) continue;
                    column = col;
                    break;
                }
                wrapperEvent = new CellEditEvent((UIComponent)this, behaviorEvent.getBehavior(), rowIndex, column);
            }
            wrapperEvent.setPhaseId(event.getPhaseId());
            super.queueEvent((FacesEvent)wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    public UIColumn findColumn(String clientId) {
        for (UIColumn column : this.getColumns()) {
            if (!column.getColumnKey().equals(clientId)) continue;
            return column;
        }
        FacesContext context = this.getFacesContext();
        ColumnGroup headerGroup = this.getColumnGroup("header");
        for (UIComponent row : headerGroup.getChildren()) {
            for (UIComponent col : row.getChildren()) {
                if (!col.getClientId(context).equals(clientId)) continue;
                return (UIColumn)col;
            }
        }
        throw new FacesException("Cannot find column with key: " + clientId);
    }

    public ColumnGroup getColumnGroup(String target) {
        for (UIComponent child : this.getChildren()) {
            ColumnGroup colGroup;
            String type;
            if (!(child instanceof ColumnGroup) || (type = (colGroup = (ColumnGroup)child).getType()) == null || !type.equals(target)) continue;
            return colGroup;
        }
        return null;
    }

    public boolean hasFooterColumn() {
        for (UIComponent child : this.getChildren()) {
            UIColumn column;
            if (!child.isRendered() || !(child instanceof UIColumn) || (column = (UIColumn)child).getFacet("footer") == null && column.getFooterText() == null) continue;
            return true;
        }
        return false;
    }

    public void loadLazyData() {
        DataModel model = this.getDataModel();
        if (model != null && model instanceof LazyDataModel) {
            RequestContext requestContext;
            LazyDataModel lazyModel = (LazyDataModel)model;
            List data = null;
            data = this.isMultiSort() ? lazyModel.load(this.getFirst(), this.getRows(), this.getMultiSortMeta(), this.getFilters()) : lazyModel.load(this.getFirst(), this.getRows(), this.resolveSortField(), this.convertSortOrder(), this.getFilters());
            lazyModel.setPageSize(this.getRows());
            lazyModel.setWrappedData(data);
            if (this.isPaginator() && (requestContext = RequestContext.getCurrentInstance()) != null) {
                requestContext.addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    protected String resolveSortField() {
        UIColumn column = this.getSortColumn();
        String sortField = null;
        ValueExpression sortVE = this.getValueExpression("sortBy");
        if (column == null) {
            sortField = this.resolveStaticField(sortVE);
        } else if (column.isDynamic()) {
            ((DynamicColumn)column).applyStatelessModel();
            sortField = this.resolveDynamicField(sortVE);
        } else {
            sortField = this.resolveStaticField(sortVE);
        }
        return sortField;
    }

    protected SortOrder convertSortOrder() {
        String sortOrder = this.getSortOrder();
        if (sortOrder == null) {
            return SortOrder.UNSORTED;
        }
        return SortOrder.valueOf(sortOrder.toUpperCase(Locale.ENGLISH));
    }

    public String resolveStaticField(ValueExpression expression) {
        if (expression != null) {
            String expressionString = expression.getExpressionString();
            expressionString = expressionString.substring(2, expressionString.length() - 1);
            return expressionString.substring(expressionString.indexOf(".") + 1);
        }
        return null;
    }

    public String resolveDynamicField(ValueExpression expression) {
        if (expression != null) {
            String expressionString = expression.getExpressionString();
            expressionString = expressionString.substring(expressionString.indexOf("[") + 1, expressionString.indexOf("]"));
            expressionString = "#{" + expressionString + "}";
            FacesContext context = this.getFacesContext();
            ELContext eLContext = context.getELContext();
            ValueExpression dynaVE = context.getApplication().getExpressionFactory().createValueExpression(eLContext, expressionString, String.class);
            return (String)dynaVE.getValue(eLContext);
        }
        return null;
    }

    public void clearLazyCache() {
        LazyDataModel model = (LazyDataModel)this.getDataModel();
        model.setWrappedData(null);
    }

    public Map<String, String> getFilters() {
        return (Map)this.getStateHelper().eval((Serializable)((Object)"filters"), new HashMap());
    }

    public void setFilters(Map<String, String> filters) {
        this.getStateHelper().put((Serializable)((Object)"filters"), filters);
    }

    public boolean isReset() {
        return this.reset;
    }

    public void resetValue() {
        this.setValue(null);
        this.setFilteredValue(null);
        this.setFilters(null);
    }

    public void reset() {
        this.resetValue();
        this.setFirst(0);
        this.reset = true;
    }

    public boolean isFilteringEnabled() {
        Object value = this.getStateHelper().get((Serializable)((Object)"filtering"));
        return value != null;
    }

    public void enableFiltering() {
        this.getStateHelper().put((Serializable)((Object)"filtering"), (Object)true);
    }

    public RowExpansion getRowExpansion() {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof RowExpansion)) continue;
            return (RowExpansion)kid;
        }
        return null;
    }

    public Object getValue() {
        Object value = super.getValue();
        List filteredValue = this.getFilteredValue();
        if (filteredValue != null) {
            if (value instanceof SelectableDataModel) {
                return this.selectableDataModelWrapper == null ? (this.selectableDataModelWrapper = new SelectableDataModelWrapper((SelectableDataModel)value, filteredValue)) : this.selectableDataModelWrapper;
            }
            return filteredValue;
        }
        return value;
    }

    public void setSelectableDataModelWrapper(SelectableDataModelWrapper wrapper) {
        this.selectableDataModelWrapper = wrapper;
    }

    public Object getLocalSelection() {
        return this.getStateHelper().get((Serializable)((Object)PropertyKeys.selection));
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public boolean isRequestSource(FacesContext context) {
        String partialSource = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.source");
        return partialSource != null && this.getClientId(context).equals(partialSource);
    }

    public boolean isBodyUpdate(FacesContext context) {
        String clientId = this.getClientId(context);
        return context.getExternalContext().getRequestParameterMap().containsKey(clientId + "_updateBody");
    }

    public SubTable getSubTable() {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof SubTable)) continue;
            return (SubTable)kid;
        }
        return null;
    }

    public Object getRowKeyFromModel(Object object) {
        DataModel model = this.getDataModel();
        if (!(model instanceof SelectableDataModel)) {
            throw new FacesException("DataModel must implement org.primefaces.model.SelectableDataModel when selection is enabled.");
        }
        return ((SelectableDataModel)this.getDataModel()).getRowKey(object);
    }

    public Object getRowData(String rowKey) {
        boolean hasRowKeyVe;
        boolean bl = hasRowKeyVe = this.getValueExpression("rowKey") != null;
        if (hasRowKeyVe) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            String var = this.getVar();
            Collection data = (Collection)this.getDataModel().getWrappedData();
            for (Object object : data) {
                requestMap.put(var, object);
                if (!String.valueOf(this.getRowKey()).equals(rowKey)) continue;
                return object;
            }
            return null;
        }
        DataModel model = this.getDataModel();
        if (!(model instanceof SelectableDataModel)) {
            throw new FacesException("DataModel must implement org.primefaces.model.SelectableDataModel when selection is enabled or you need to define rowKey attribute");
        }
        return ((SelectableDataModel)this.getDataModel()).getRowData(rowKey);
    }

    void findSelectedRowKeys() {
        block6: {
            Object selection = this.getSelection();
            this.selectedRowKeys = new ArrayList<Object>();
            boolean hasRowKeyVe = this.getValueExpression("rowKey") != null;
            String var = this.getVar();
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            if (!this.isSelectionEnabled() || selection == null) break block6;
            if (this.isSingleSelectionMode()) {
                this.addToSelectedRowKeys(selection, requestMap, var, hasRowKeyVe);
            } else if (selection.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(selection); ++i) {
                    this.addToSelectedRowKeys(Array.get(selection, i), requestMap, var, hasRowKeyVe);
                }
            } else {
                List list = (List)selection;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    this.addToSelectedRowKeys(it.next(), requestMap, var, hasRowKeyVe);
                }
            }
        }
    }

    void addToSelectedRowKeys(Object object, Map<String, Object> map, String var, boolean hasRowKey) {
        if (hasRowKey) {
            map.put(var, object);
            this.selectedRowKeys.add(this.getRowKey());
        } else {
            this.selectedRowKeys.add(this.getRowKeyFromModel(object));
        }
    }

    List<Object> getSelectedRowKeys() {
        return this.selectedRowKeys;
    }

    String getSelectedRowKeysAsString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Object> iter = this.getSelectedRowKeys().iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public SummaryRow getSummaryRow() {
        for (UIComponent kid : this.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof SummaryRow)) continue;
            return (SummaryRow)kid;
        }
        return null;
    }

    public int getColumnsCount() {
        if (this.columnsCount == -1) {
            this.columnsCount = 0;
            for (UIComponent kid : this.getChildren()) {
                if (!kid.isRendered()) continue;
                if (kid instanceof Columns) {
                    Columns uicolumns = (Columns)kid;
                    Collection collection = (Collection)uicolumns.getValue();
                    if (collection == null) continue;
                    this.columnsCount += collection.size();
                    continue;
                }
                if (kid instanceof Column) {
                    ++this.columnsCount;
                    continue;
                }
                if (!(kid instanceof SubTable)) continue;
                SubTable subTable = (SubTable)kid;
                for (UIComponent subTableKid : subTable.getChildren()) {
                    if (!subTableKid.isRendered() || !(subTableKid instanceof Column)) continue;
                    ++this.columnsCount;
                }
            }
        }
        return this.columnsCount;
    }

    public List<UIColumn> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<UIColumn>();
            FacesContext context = this.getFacesContext();
            char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
            for (UIComponent child : this.getChildren()) {
                if (child instanceof Column) {
                    this.columns.add((UIColumn)child);
                    continue;
                }
                if (!(child instanceof Columns)) continue;
                Columns uiColumns = (Columns)child;
                String uiColumnsClientId = uiColumns.getClientId(context);
                for (int i = 0; i < uiColumns.getRowCount(); ++i) {
                    DynamicColumn dynaColumn = new DynamicColumn(i, uiColumns);
                    dynaColumn.setColumnKey(uiColumnsClientId + separator + i);
                    this.columns.add(dynaColumn);
                }
            }
        }
        return this.columns;
    }

    public void setColumns(List<UIColumn> columns) {
        this.columns = columns;
    }

    public String getScrollState() {
        String name;
        Map params = this.getFacesContext().getExternalContext().getRequestParameterMap();
        String value = (String)params.get(name = this.getClientId() + "_scrollState");
        return value == null ? "0,0" : value;
    }

    @Override
    protected boolean shouldProcessChildren(FacesContext context) {
        return !context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_skipChildren");
    }

    public void setSortColumn(UIColumn column) {
        this.sortColumn = column;
    }

    public UIColumn getSortColumn() {
        return this.sortColumn;
    }

    public boolean isMultiSort() {
        String sortMode = this.getSortMode();
        return sortMode != null && sortMode.equals("multiple");
    }

    public List<SortMeta> getMultiSortMeta() {
        ValueExpression ve;
        if (this.multiSortMeta == null && (ve = this.getValueExpression("sortBy")) != null) {
            this.multiSortMeta = (List)ve.getValue(this.getFacesContext().getELContext());
        }
        return this.multiSortMeta;
    }

    public void setMultiSortMeta(List<SortMeta> value) {
        this.multiSortMeta = value;
    }

    public boolean isDefaultSorted() {
        Object value = this.getStateHelper().get((Serializable)((Object)"defaultSorted"));
        return value != null;
    }

    public void setDefaultSorted() {
        this.getStateHelper().put((Serializable)((Object)"defaultSorted"), (Object)true);
    }

    @Override
    public boolean isRTL() {
        return this.getDir().equalsIgnoreCase("rtl");
    }

    public String resolveSelectionMode() {
        String tableSelectionMode = this.getSelectionMode();
        String columnSelectionMode = this.getColumnSelectionMode();
        String selectionMode = null;
        if (tableSelectionMode != null) {
            selectionMode = tableSelectionMode;
        } else if (columnSelectionMode != null) {
            selectionMode = columnSelectionMode.equals("single") ? "radio" : "checkbox";
        }
        return selectionMode;
    }

    @Override
    protected boolean requiresColumns() {
        return true;
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    @Override
    public String resolveWidgetVar() {
        FacesContext context = FacesContext.getCurrentInstance();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    public void handleAttribute(String name, Object value) {
        String cname;
        ArrayList<String> setAttributes = (ArrayList<String>)this.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (setAttributes == null && (cname = this.getClass().getName()) != null && cname.startsWith(OPTIMIZED_PACKAGE)) {
            setAttributes = new ArrayList<String>(6);
            this.getAttributes().put("javax.faces.component.UIComponentBase.attributesThatAreSet", setAttributes);
        }
        if (setAttributes != null && value == null) {
            ValueExpression ve = this.getValueExpression(name);
            if (ve == null) {
                setAttributes.remove(name);
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
            }
        }
    }

    static {
        FEATURES.put(DataTableFeatureKey.DRAGGABLE_COLUMNS, new DraggableColumnsFeature());
        FEATURES.put(DataTableFeatureKey.FILTER, new FilterFeature());
        FEATURES.put(DataTableFeatureKey.PAGE, new PageFeature());
        FEATURES.put(DataTableFeatureKey.SORT, new SortFeature());
        FEATURES.put(DataTableFeatureKey.RESIZABLE_COLUMNS, new ResizableColumnsFeature());
        FEATURES.put(DataTableFeatureKey.SELECT, new SelectionFeature());
        FEATURES.put(DataTableFeatureKey.ROW_EDIT, new RowEditFeature());
        FEATURES.put(DataTableFeatureKey.ROW_EXPAND, new RowExpandFeature());
        FEATURES.put(DataTableFeatureKey.SCROLL, new ScrollFeature());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        scrollable,
        scrollHeight,
        scrollWidth,
        selectionMode,
        selection,
        emptyMessage,
        style,
        styleClass,
        liveScroll,
        rowStyleClass,
        onExpandStart,
        resizableColumns,
        sortBy,
        sortOrder,
        sortFunction,
        scrollRows,
        rowKey,
        filterEvent,
        filterDelay,
        tableStyle,
        tableStyleClass,
        draggableColumns,
        editable,
        filteredValue,
        sortMode,
        editMode,
        editingRow,
        cellSeparator,
        summary,
        frozenRows,
        dir,
        liveResize;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

