/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVExporter
extends Exporter {
    @Override
    public void export(FacesContext context, DataTable table, String filename, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        ExternalContext externalContext = context.getExternalContext();
        this.configureResponse(externalContext, filename);
        Writer writer = externalContext.getResponseOutputWriter();
        this.addColumnFacets(writer, table, Exporter.ColumnType.HEADER);
        if (pageOnly) {
            this.exportPageOnly(context, table, writer);
        } else if (selectionOnly) {
            this.exportSelectionOnly(context, table, writer);
        } else {
            this.exportAll(context, table, writer);
        }
        if (table.hasFooterColumn()) {
            this.addColumnFacets(writer, table, Exporter.ColumnType.FOOTER);
        }
        writer.flush();
        writer.close();
        externalContext.responseFlushBuffer();
    }

    protected void addColumnFacets(Writer writer, DataTable table, Exporter.ColumnType columnType) throws IOException {
        boolean firstCellWritten = false;
        for (UIColumn col : table.getColumns()) {
            if (!col.isRendered()) continue;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyModel();
            }
            if (!col.isExportable()) continue;
            if (firstCellWritten) {
                writer.write(",");
            }
            this.addColumnValue(writer, col.getFacet(columnType.facet()));
            firstCellWritten = true;
        }
        writer.write("\n");
    }

    protected void exportPageOnly(FacesContext context, DataTable table, Writer writer) throws IOException {
        int first = table.getFirst();
        int rowsToExport = first + table.getRows();
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(table, writer, rowIndex);
        }
    }

    protected void exportSelectionOnly(FacesContext context, DataTable table, Writer writer) throws IOException {
        Object selection = table.getSelection();
        String var = table.getVar();
        if (selection != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (selection.getClass().isArray()) {
                int size = Array.getLength(selection);
                for (int i = 0; i < size; ++i) {
                    requestMap.put(var, Array.get(selection, i));
                    this.exportCells(table, writer);
                }
            } else {
                requestMap.put(var, selection);
                this.exportCells(table, writer);
            }
        }
    }

    protected void exportAll(FacesContext context, DataTable table, Writer writer) throws IOException {
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rows = table.getRows();
        boolean lazy = table.isLazy();
        if (lazy) {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                if (rowIndex % rows == 0) {
                    table.setFirst(rowIndex);
                    table.loadLazyData();
                }
                this.exportRow(table, writer, rowIndex);
            }
            table.setFirst(first);
            table.loadLazyData();
        } else {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, writer, rowIndex);
            }
            table.setFirst(first);
        }
    }

    protected void exportRow(DataTable table, Writer writer, int rowIndex) throws IOException {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        this.exportCells(table, writer);
        writer.write("\n");
    }

    protected void exportCells(DataTable table, Writer writer) throws IOException {
        boolean firstCellWritten = false;
        for (UIColumn col : table.getColumns()) {
            if (!col.isRendered()) continue;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyModel();
            }
            if (!col.isExportable()) continue;
            if (firstCellWritten) {
                writer.write(",");
            }
            this.addColumnValue(writer, col.getChildren());
            firstCellWritten = true;
        }
    }

    protected void configureResponse(ExternalContext externalContext, String filename) {
        externalContext.setResponseContentType("text/csv");
        externalContext.setResponseHeader("Expires", "0");
        externalContext.setResponseHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        externalContext.setResponseHeader("Pragma", "public");
        externalContext.setResponseHeader("Content-disposition", "attachment;filename=" + filename + ".csv");
        externalContext.addResponseCookie("primefaces.download", "true", new HashMap());
    }

    protected void addColumnValues(Writer writer, List<UIColumn> columns) throws IOException {
        Iterator<UIColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            this.addColumnValue(writer, iterator.next().getChildren());
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
    }

    protected void addColumnValue(Writer writer, UIComponent component) throws IOException {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        value = value.replaceAll("\"", "\"\"");
        writer.write("\"" + value + "\"");
    }

    protected void addColumnValue(Writer writer, List<UIComponent> components) throws IOException {
        StringBuilder builder = new StringBuilder();
        FacesContext context = FacesContext.getCurrentInstance();
        for (UIComponent component : components) {
            if (!component.isRendered()) continue;
            String value = this.exportValue(context, component);
            value = value.replaceAll("\"", "\"\"");
            builder.append(value);
        }
        writer.write("\"" + builder.toString() + "\"");
    }
}

