/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.graphicimage;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.graphicimage.GraphicImage;
import org.primefaces.model.StreamedContent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.HTML;

public class GraphicImageRenderer
extends CoreRenderer {
    private static final Logger logger = Logger.getLogger(GraphicImageRenderer.class.getName());

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        GraphicImage image = (GraphicImage)component;
        String clientId = image.getClientId(context);
        String imageSrc = this.getImageSrc(context, image);
        writer.startElement("img", (UIComponent)image);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("src", (Object)imageSrc, null);
        if (image.getAlt() == null) {
            writer.writeAttribute("alt", (Object)"", null);
        }
        if (image.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)image.getStyleClass(), "styleClass");
        }
        this.renderPassThruAttributes(context, (UIComponent)image, HTML.IMG_ATTRS);
        writer.endElement("img");
    }

    protected String getImageSrc(FacesContext context, GraphicImage image) {
        String src = null;
        String name = image.getName();
        if (name != null) {
            String libName = image.getLibrary();
            ResourceHandler handler = context.getApplication().getResourceHandler();
            Resource res = handler.createResource(name, libName);
            if (res == null) {
                return "RES_NOT_FOUND";
            }
            String requestPath = res.getRequestPath();
            return context.getExternalContext().encodeResourceURL(requestPath);
        }
        Object value = image.getValue();
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            src = this.getResourceURL(context, (String)value);
        } else if (value instanceof StreamedContent) {
            StreamedContent streamedContent = (StreamedContent)value;
            Resource resource = context.getApplication().getResourceHandler().createResource("dynamiccontent.properties", "primefaces", streamedContent.getContentType());
            String resourcePath = resource.getRequestPath();
            String rid = this.createUniqueContentId(context);
            StringBuilder builder = new StringBuilder(resourcePath);
            builder.append("&").append("pfdrid").append("=").append(rid);
            for (UIComponent kid : image.getChildren()) {
                if (!(kid instanceof UIParameter)) continue;
                UIParameter param = (UIParameter)kid;
                builder.append("&").append(param.getName()).append("=").append(param.getValue());
            }
            src = builder.toString();
            context.getExternalContext().getSessionMap().put(rid, image.getValueExpression("value").getExpressionString());
        }
        if (!image.isCache()) {
            src = src + (src.contains("?") ? "&" : "?");
            src = src + "primefaces_image=" + UUID.randomUUID().toString();
        }
        src = context.getExternalContext().encodeResourceURL(src);
        return src;
    }

    protected String createUniqueContentId(FacesContext context) {
        Map session = context.getExternalContext().getSessionMap();
        String key = this.generateKey();
        while (session.containsKey(key)) {
            key = this.generateKey();
        }
        return key;
    }

    protected String generateKey() {
        StringBuilder builder = new StringBuilder();
        return builder.append("pfdrid").append("_").append(UUID.randomUUID().toString()).toString();
    }
}

