/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.outputlabel;

import java.io.IOException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.outputlabel.OutputLabel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.HTML;

public class OutputLabelRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        OutputLabel label = (OutputLabel)component;
        String clientId = label.getClientId();
        Object value = label.getValue();
        UIComponent target = null;
        String targetClientId = null;
        UIInput input = null;
        String styleClass = label.getStyleClass();
        String string = styleClass = styleClass == null ? "ui-outputlabel" : "ui-outputlabel " + styleClass;
        if (label.getFor() != null) {
            target = this.findTarget(context, label);
            String string2 = targetClientId = target instanceof InputHolder ? ((InputHolder)target).getInputClientId() : target.getClientId(context);
            if (target instanceof UIInput) {
                input = (UIInput)target;
                if (input.getAttributes().get("label") == null || input.getValueExpression("label") == null) {
                    ValueExpression ve = label.getValueExpression("value");
                    if (ve != null) {
                        input.setValueExpression("label", ve);
                    } else {
                        input.getAttributes().put("label", value);
                    }
                }
                if (!input.isValid()) {
                    styleClass = styleClass + " ui-state-error";
                }
            }
        }
        writer.startElement("label", (UIComponent)label);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "id");
        this.renderPassThruAttributes(context, (UIComponent)label, HTML.LABEL_ATTRS);
        if (target != null) {
            writer.writeAttribute("for", (Object)targetClientId, "for");
        }
        if (value != null) {
            String text = value.toString();
            if (label.isEscape()) {
                writer.writeText((Object)text, "value");
            } else {
                writer.write(text);
            }
        }
        this.renderChildren(context, (UIComponent)label);
        if (input != null && input.isRequired()) {
            writer.startElement("span", (UIComponent)label);
            writer.writeAttribute("class", (Object)"ui-outputlabel-rfi", null);
            writer.write("*");
            writer.endElement("span");
        }
        writer.endElement("label");
    }

    protected UIComponent findTarget(FacesContext context, OutputLabel label) {
        UIComponent _forComponent = null;
        String _for = label.getFor();
        if (_for != null && (_forComponent = label.findComponent(_for)) == null) {
            throw new FacesException("Cannot find component with identifier \"" + _for + "\" referenced from \"" + label.getClientId(context) + "\".");
        }
        return _forComponent;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

