/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.photocam;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.xml.bind.DatatypeConverter;
import org.primefaces.component.photocam.PhotoCam;
import org.primefaces.event.CaptureEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.AgentUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class PhotoCamRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        PhotoCam cam = (PhotoCam)component;
        String clientId = cam.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            String image = (String)params.get(clientId);
            image = image.substring(22);
            CaptureEvent event = new CaptureEvent((UIComponent)cam, DatatypeConverter.parseBase64Binary((String)image), image);
            event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            cam.queueEvent(event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!AgentUtils.isIE(context)) {
            PhotoCam cam = (PhotoCam)component;
            this.encodeMarkup(context, cam);
            this.encodeScript(context, cam);
        }
    }

    protected void encodeMarkup(FacesContext context, PhotoCam cam) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = cam.getClientId(context);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (cam.getStyle() != null) {
            writer.writeAttribute("style", (Object)cam.getStyle(), null);
        }
        if (cam.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)cam.getStyleClass(), null);
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, PhotoCam cam) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = cam.getClientId(context);
        String camera = this.getResourceRequestPath(context, "photocam/photocam.swf");
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("PhotoCam", cam.resolveWidgetVar(), clientId, true).attr("camera", camera);
        if (cam.getUpdate() != null) {
            wb.attr("update", ComponentUtils.findClientIds(context, (UIComponent)cam, cam.getUpdate()));
        }
        if (cam.getProcess() != null) {
            wb.attr("process", ComponentUtils.findClientIds(context, (UIComponent)cam, cam.getProcess()));
        }
        this.startScript(writer, clientId);
        writer.write(wb.build());
        this.endScript(writer);
    }
}

