/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.resizable;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.resizable.Resizable;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class ResizableRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Resizable resizable = (Resizable)component;
        String clientId = resizable.getClientId(context);
        UIComponent target = this.findTarget(context, resizable);
        String targetId = target.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("Resizable", resizable.resolveWidgetVar(), clientId, false).attr("target", targetId).attr("minWidth", resizable.getMinWidth(), Integer.MIN_VALUE).attr("maxWidth", resizable.getMaxWidth(), Integer.MAX_VALUE).attr("minHeight", resizable.getMinHeight(), Integer.MIN_VALUE).attr("maxHeight", resizable.getMaxHeight(), Integer.MAX_VALUE);
        if (resizable.isAnimate()) {
            wb.attr("animate", true).attr("animateEasing", resizable.getEffect()).attr("animateDuration", resizable.getEffectDuration());
        }
        if (resizable.isProxy()) {
            wb.attr("helper", "ui-resizable-proxy");
        }
        wb.attr("handles", resizable.getHandles(), null).attr("grid", resizable.getGrid(), 1).attr("aspectRatio", resizable.isAspectRatio(), false).attr("ghost", resizable.isGhost(), false);
        if (resizable.isContainment()) {
            wb.attr("containment", "PrimeFaces.escapeClientId('" + resizable.getParent().getClientId(context) + "')");
        }
        wb.callback("onStart", "function(event,ui)", resizable.getOnStart()).callback("onResize", "function(event,ui)", resizable.getOnResize()).callback("onStop", "function(event,ui)", resizable.getOnStop());
        this.encodeClientBehaviors(context, resizable, wb);
        this.startScript(writer, clientId);
        if (target instanceof UIGraphic) {
            writer.write("$(PrimeFaces.escapeClientId('" + targetId + "')).load(function(){");
        } else {
            writer.write("$(function(){");
        }
        writer.write(wb.build());
        writer.write("});");
        this.endScript(writer);
    }

    protected UIComponent findTarget(FacesContext context, Resizable resizable) {
        String _for = resizable.getFor();
        if (_for != null) {
            UIComponent component = resizable.findComponent(_for);
            if (component == null) {
                throw new FacesException("Cannot find component \"" + _for + "\" in view.");
            }
            return component;
        }
        return resizable.getParent();
    }
}

