/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectonelistbox;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectOne;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.primefaces.component.column.Column;
import org.primefaces.component.selectonelistbox.SelectOneListbox;
import org.primefaces.renderkit.SelectOneRenderer;
import org.primefaces.util.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectOneListboxRenderer
extends SelectOneRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return context.getRenderKit().getRenderer("javax.faces.SelectOne", "javax.faces.Listbox").getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectOneListbox listbox = (SelectOneListbox)component;
        this.encodeMarkup(context, listbox);
        this.encodeScript(context, listbox);
    }

    protected void encodeMarkup(FacesContext context, SelectOneListbox listbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = listbox.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)listbox);
        String style = listbox.getStyle();
        String styleClass = listbox.getStyleClass();
        styleClass = styleClass == null ? "ui-selectonelistbox ui-inputfield ui-widget ui-widget-content ui-corner-all" : "ui-selectonelistbox ui-inputfield ui-widget ui-widget-content ui-corner-all " + styleClass;
        styleClass = listbox.isDisabled() ? styleClass + " ui-state-disabled" : styleClass;
        styleClass = !listbox.isValid() ? styleClass + " ui-state-error" : styleClass;
        writer.startElement("div", (UIComponent)listbox);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeInput(context, listbox, clientId, selectItems);
        this.encodeList(context, listbox, selectItems);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectOneListbox listbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = listbox.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("SelectOneListbox", listbox.resolveWidgetVar(), clientId, false).attr("disabled", listbox.isDisabled(), false);
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)listbox, wb);
        this.startScript(writer, clientId);
        writer.write(wb.build());
        this.endScript(writer);
    }

    protected void encodeInput(FacesContext context, SelectOneListbox listbox, String clientId, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputid = clientId + "_input";
        writer.startElement("div", (UIComponent)listbox);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("select", (UIComponent)listbox);
        writer.writeAttribute("id", (Object)inputid, "id");
        writer.writeAttribute("name", (Object)inputid, null);
        writer.writeAttribute("size", (Object)"2", null);
        if (listbox.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)listbox.getTabindex(), null);
        }
        if (listbox.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)listbox.getOnchange(), null);
        }
        this.encodeSelectItems(context, listbox, selectItems);
        writer.endElement("select");
        writer.endElement("div");
    }

    protected void encodeList(FacesContext context, SelectOneListbox listbox, List<SelectItem> selectItems) throws IOException {
        boolean customContent;
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = listbox.getConverter();
        Object values = this.getValues((UISelectOne)listbox);
        Object submittedValues = this.getSubmittedValues((UIComponent)listbox);
        boolean bl = customContent = listbox.getVar() != null;
        if (customContent) {
            writer.startElement("table", null);
            writer.writeAttribute("class", (Object)"ui-selectlistbox-list", null);
            writer.startElement("tbody", null);
            for (SelectItem selectItem : selectItems) {
                this.encodeItem(context, listbox, selectItem, values, submittedValues, converter, customContent);
            }
            writer.endElement("tbody");
            writer.endElement("table");
        } else {
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-selectlistbox-list", null);
            for (SelectItem selectItem : selectItems) {
                this.encodeItem(context, listbox, selectItem, values, submittedValues, converter, customContent);
            }
            writer.endElement("ul");
        }
    }

    protected void encodeItem(FacesContext context, SelectOneListbox listbox, SelectItem option, Object values, Object submittedValues, Converter converter, boolean customContent) throws IOException {
        Object itemValue;
        Object valuesArray;
        String itemClass;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)listbox, converter, option.getValue());
        boolean disabled = option.isDisabled() || listbox.isDisabled();
        String string = itemClass = disabled ? "ui-selectlistbox-item ui-corner-all ui-state-disabled" : "ui-selectlistbox-item ui-corner-all";
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)listbox, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        if (selected) {
            itemClass = itemClass + " ui-state-highlight";
        }
        if (customContent) {
            String var = listbox.getVar();
            context.getExternalContext().getRequestMap().put(var, option.getValue());
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)itemClass, null);
            if (option.getDescription() != null) {
                writer.writeAttribute("title", (Object)option.getDescription(), null);
            }
            for (UIComponent child : listbox.getChildren()) {
                if (!(child instanceof Column) || !child.isRendered()) continue;
                writer.startElement("td", null);
                child.encodeAll(context);
                writer.endElement("td");
            }
            writer.endElement("tr");
        } else {
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)itemClass, null);
            if (option.isEscape()) {
                writer.writeText((Object)option.getLabel(), null);
            } else {
                writer.write(option.getLabel());
            }
            writer.endElement("li");
        }
    }

    protected void encodeSelectItems(FacesContext context, SelectOneListbox listbox, List<SelectItem> selectItems) throws IOException {
        Converter converter = listbox.getConverter();
        Object values = this.getValues((UISelectOne)listbox);
        Object submittedValues = this.getSubmittedValues((UIComponent)listbox);
        for (SelectItem selectItem : selectItems) {
            this.encodeOption(context, listbox, selectItem, values, submittedValues, converter);
        }
    }

    protected void encodeOption(FacesContext context, SelectOneListbox listbox, SelectItem option, Object values, Object submittedValues, Converter converter) throws IOException {
        Object itemValue;
        Object valuesArray;
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)listbox, converter, option.getValue());
        boolean bl = disabled = option.isDisabled() || listbox.isDisabled();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)listbox, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        writer.startElement("option", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (selected) {
            writer.writeAttribute("selected", (Object)"selected", null);
        }
        writer.write(option.getLabel());
        writer.endElement("option");
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectOne selectOne) {
        return selectOne.getClientId(context) + "_input";
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

