/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tabmenu;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.tabmenu.TabMenu;
import org.primefaces.util.WidgetBuilder;

public class TabMenuRenderer
extends BaseMenuRenderer {
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TabMenu menu = (TabMenu)abstractMenu;
        String clientId = menu.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("TabMenu", menu.resolveWidgetVar(), clientId, false);
        this.startScript(writer, clientId);
        writer.write(wb.build());
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, AbstractMenu component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TabMenu menu = (TabMenu)component;
        String clientId = menu.getClientId(context);
        String styleClass = menu.getStyleClass();
        styleClass = styleClass == null ? "ui-tabmenu ui-widget ui-widget-content ui-corner-all" : "ui-tabmenu ui-widget ui-widget-content ui-corner-all " + styleClass;
        int activeIndex = menu.getActiveIndex();
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (menu.getStyle() != null) {
            writer.writeAttribute("style", (Object)menu.getStyle(), "style");
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-tabmenu-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all", null);
        writer.writeAttribute("role", (Object)"tablist", null);
        int i = 0;
        for (UIComponent kid : menu.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof MenuItem)) continue;
            this.encodeItem(context, menu, (MenuItem)kid, i == activeIndex);
            ++i;
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeItem(FacesContext context, TabMenu menu, MenuItem item, boolean active) throws IOException {
        String containerClass;
        ResponseWriter writer = context.getResponseWriter();
        String string = containerClass = active ? "ui-tabmenuitem ui-state-default ui-state-active ui-corner-top" : "ui-tabmenuitem ui-state-default ui-corner-top";
        if (item.getIcon() != null) {
            containerClass = containerClass + " ui-tabmenuitem-hasicon";
        }
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)containerClass, null);
        writer.writeAttribute("role", (Object)"tab", null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(active), null);
        this.encodeMenuItem(context, item);
        writer.endElement("li");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

