/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tabview;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.RTLAware;
import org.primefaces.component.api.UIData;
import org.primefaces.component.api.Widget;
import org.primefaces.component.tabview.Tab;
import org.primefaces.event.TabChangeEvent;
import org.primefaces.event.TabCloseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="primefaces.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="primefaces.js")})
public class TabView
extends UIData
implements Widget,
RTLAware,
ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.TabView";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.TabViewRenderer";
    private static final String OPTIMIZED_PACKAGE = "org.primefaces.component.";
    public static final String CONTAINER_CLASS = "ui-tabs ui-widget ui-widget-content ui-corner-all ui-hidden-container";
    public static final String NAVIGATOR_CLASS = "ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all";
    public static final String INACTIVE_TAB_HEADER_CLASS = "ui-state-default";
    public static final String ACTIVE_TAB_HEADER_CLASS = "ui-state-default ui-tabs-selected ui-state-active";
    public static final String PANELS_CLASS = "ui-tabs-panels";
    public static final String ACTIVE_TAB_CONTENT_CLASS = "ui-tabs-panel ui-widget-content ui-corner-bottom";
    public static final String INACTIVE_TAB_CONTENT_CLASS = "ui-tabs-panel ui-widget-content ui-corner-bottom ui-helper-hidden";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("tabChange", "tabClose"));
    List<Tab> loadedTabs;

    public TabView() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
        this.handleAttribute("widgetVar", _widgetVar);
    }

    public int getActiveIndex() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.activeIndex), (Object)0);
    }

    public void setActiveIndex(int _activeIndex) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.activeIndex), (Object)_activeIndex);
        this.handleAttribute("activeIndex", _activeIndex);
    }

    public String getEffect() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.effect), null);
    }

    public void setEffect(String _effect) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.effect), (Object)_effect);
        this.handleAttribute("effect", _effect);
    }

    public String getEffectDuration() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.effectDuration), (Object)"normal");
    }

    public void setEffectDuration(String _effectDuration) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.effectDuration), (Object)_effectDuration);
        this.handleAttribute("effectDuration", _effectDuration);
    }

    public boolean isDynamic() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dynamic), (Object)false);
    }

    public void setDynamic(boolean _dynamic) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dynamic), (Object)_dynamic);
        this.handleAttribute("dynamic", _dynamic);
    }

    public boolean isCache() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.cache), (Object)true);
    }

    public void setCache(boolean _cache) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.cache), (Object)_cache);
        this.handleAttribute("cache", _cache);
    }

    public String getOnTabChange() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onTabChange), null);
    }

    public void setOnTabChange(String _onTabChange) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onTabChange), (Object)_onTabChange);
        this.handleAttribute("onTabChange", _onTabChange);
    }

    public String getOnTabShow() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onTabShow), null);
    }

    public void setOnTabShow(String _onTabShow) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onTabShow), (Object)_onTabShow);
        this.handleAttribute("onTabShow", _onTabShow);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
        this.handleAttribute("style", _style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
        this.handleAttribute("styleClass", _styleClass);
    }

    public String getOrientation() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.orientation), (Object)"top");
    }

    public void setOrientation(String _orientation) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.orientation), (Object)_orientation);
        this.handleAttribute("orientation", _orientation);
    }

    public String getOnTabClose() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onTabClose), null);
    }

    public void setOnTabClose(String _onTabClose) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onTabClose), (Object)_onTabClose);
        this.handleAttribute("onTabClose", _onTabClose);
    }

    public String getDir() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dir), (Object)"ltr");
    }

    public void setDir(String _dir) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dir), (Object)_dir);
        this.handleAttribute("dir", _dir);
    }

    public boolean isContentLoadRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_contentLoad");
    }

    private boolean isRequestSource(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public Tab findTab(String tabClientId) {
        for (UIComponent component : this.getChildren()) {
            if (!component.getClientId().equals(tabClientId)) continue;
            return (Tab)component;
        }
        return null;
    }

    public List<Tab> getLoadedTabs() {
        if (this.loadedTabs == null) {
            this.loadedTabs = new ArrayList<Tab>();
            for (UIComponent component : this.getChildren()) {
                Tab tab;
                if (!(component instanceof Tab) || !(tab = (Tab)component).isLoaded()) continue;
                this.loadedTabs.add(tab);
            }
        }
        return this.loadedTabs;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (this.isRequestSource(context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals("tabChange")) {
                String tabClientId = (String)params.get(clientId + "_newTab");
                TabChangeEvent changeEvent = new TabChangeEvent((UIComponent)this, behaviorEvent.getBehavior(), this.findTab(tabClientId));
                if (this.getVar() != null) {
                    int tabindex = Integer.parseInt((String)params.get(clientId + "_tabindex"));
                    this.setRowIndex(tabindex);
                    changeEvent.setData(this.getRowData());
                    changeEvent.setTab((Tab)((Object)this.getChildren().get(0)));
                    this.setRowIndex(-1);
                }
                changeEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)changeEvent);
            } else if (eventName.equals("tabClose")) {
                String tabClientId = (String)params.get(clientId + "_closeTab");
                TabCloseEvent closeEvent = new TabCloseEvent((UIComponent)this, behaviorEvent.getBehavior(), this.findTab(tabClientId));
                if (this.getVar() != null) {
                    int tabindex = Integer.parseInt((String)params.get(clientId + "_tabindex"));
                    this.setRowIndex(tabindex);
                    closeEvent.setData(this.getRowData());
                    closeEvent.setTab((Tab)((Object)this.getChildren().get(0)));
                    this.setRowIndex(-1);
                }
                closeEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)closeEvent);
            }
        } else {
            super.queueEvent(event);
        }
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        if (this.isDynamic() && this.getVar() == null) {
            for (Tab tab : this.getLoadedTabs()) {
                tab.processDecodes(context);
            }
            this.decode(context);
        } else if (this.getVar() == null) {
            Iterator kids = this.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                kid.processDecodes(context);
            }
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    @Override
    public void processValidators(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        if (this.isDynamic() && this.getVar() == null) {
            for (Tab tab : this.getLoadedTabs()) {
                tab.processValidators(context);
            }
        } else if (this.getVar() == null) {
            Iterator kids = this.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                kid.processValidators(context);
            }
        } else {
            super.processValidators(context);
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        ValueExpression expr = this.getValueExpression("activeIndex");
        if (expr != null) {
            expr.setValue(this.getFacesContext().getELContext(), (Object)this.getActiveIndex());
            this.resetActiveIndex();
        }
        if (this.isDynamic() && this.getVar() == null) {
            for (Tab tab : this.getLoadedTabs()) {
                tab.processUpdates(context);
            }
        } else if (this.getVar() == null) {
            Iterator kids = this.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                kid.processUpdates(context);
            }
        } else {
            super.processUpdates(context);
        }
    }

    protected void resetActiveIndex() {
        this.getStateHelper().remove((Serializable)((Object)PropertyKeys.activeIndex));
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        if (this.getVar() == null) {
            block9: {
                if (!this.isVisitable(context)) {
                    return false;
                }
                FacesContext facesContext = context.getFacesContext();
                this.pushComponentToEL(facesContext, null);
                try {
                    VisitResult result = context.invokeVisitCallback((UIComponent)this, callback);
                    if (result == VisitResult.COMPLETE) {
                        boolean bl = true;
                        return bl;
                    }
                    if (result != VisitResult.ACCEPT) break block9;
                    Iterator kids = this.getFacetsAndChildren();
                    while (kids.hasNext()) {
                        boolean done = ((UIComponent)kids.next()).visitTree(context, callback);
                        if (!done) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    this.popComponentFromEL(facesContext);
                }
            }
            return false;
        }
        return super.visitTree(context, callback);
    }

    @Override
    public boolean isRTL() {
        return this.getDir().equalsIgnoreCase("rtl");
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    @Override
    public String resolveWidgetVar() {
        FacesContext context = FacesContext.getCurrentInstance();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    public void handleAttribute(String name, Object value) {
        String cname;
        ArrayList<String> setAttributes = (ArrayList<String>)this.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (setAttributes == null && (cname = this.getClass().getName()) != null && cname.startsWith(OPTIMIZED_PACKAGE)) {
            setAttributes = new ArrayList<String>(6);
            this.getAttributes().put("javax.faces.component.UIComponentBase.attributesThatAreSet", setAttributes);
        }
        if (setAttributes != null && value == null) {
            ValueExpression ve = this.getValueExpression(name);
            if (ve == null) {
                setAttributes.remove(name);
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        activeIndex,
        effect,
        effectDuration,
        dynamic,
        cache,
        onTabChange,
        onTabShow,
        style,
        styleClass,
        orientation,
        onTabClose,
        dir;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

