/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class HeadRenderer
extends Renderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("head", component);
        UIComponent first = component.getFacet("first");
        if (first != null) {
            first.encodeAll(context);
        }
        UIViewRoot viewRoot = context.getViewRoot();
        ListIterator iter = viewRoot.getComponentResources(context, "head").listIterator();
        ArrayList<UIComponent> styles = new ArrayList<UIComponent>();
        ArrayList<UIComponent> scripts = new ArrayList<UIComponent>();
        while (iter.hasNext()) {
            UIComponent resource = (UIComponent)iter.next();
            String name = (String)resource.getAttributes().get("name");
            if (name == null) continue;
            if (name.endsWith(".css")) {
                styles.add(resource);
                continue;
            }
            if (!name.endsWith(".js")) continue;
            scripts.add(resource);
        }
        String theme = null;
        String themeParamValue = context.getExternalContext().getInitParameter("primefaces.THEME");
        if (themeParamValue != null) {
            ELContext elContext = context.getELContext();
            ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
            ValueExpression ve = expressionFactory.createValueExpression(elContext, themeParamValue, String.class);
            theme = (String)ve.getValue(elContext);
        } else {
            theme = "aristo";
        }
        if (theme != null && !theme.equals("none")) {
            this.encodeTheme(context, "primefaces-" + theme, "theme.css");
        }
        for (UIComponent style : styles) {
            style.encodeAll(context);
        }
        UIComponent middle = component.getFacet("middle");
        if (middle != null) {
            middle.encodeAll(context);
        }
        for (UIComponent script : scripts) {
            script.encodeAll(context);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent last = component.getFacet("last");
        if (last != null) {
            last.encodeAll(context);
        }
        writer.endElement("head");
    }

    protected void encodeTheme(FacesContext context, String library, String resource) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Resource themeResource = context.getApplication().getResourceHandler().createResource(resource, library);
        if (themeResource == null) {
            throw new FacesException("Error loading theme, cannot find \"" + resource + "\" resource of \"" + library + "\" library");
        }
        writer.startElement("link", null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        writer.writeAttribute("href", (Object)themeResource.getRequestPath(), null);
        writer.endElement("link");
    }
}

