/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.primefaces.renderkit.CoreRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InputRenderer
extends CoreRenderer {
    protected List<SelectItem> getSelectItems(FacesContext context, UIInput component) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (UIComponent child : component.getChildren()) {
            UISelectItems uiSelectItems;
            Object value;
            if (child instanceof UISelectItem) {
                UISelectItem uiSelectItem = (UISelectItem)child;
                Object selectItemValue = uiSelectItem.getValue();
                if (selectItemValue == null) {
                    selectItems.add(new SelectItem(uiSelectItem.getItemValue(), uiSelectItem.getItemLabel(), uiSelectItem.getItemDescription(), uiSelectItem.isItemDisabled(), uiSelectItem.isItemEscaped(), uiSelectItem.isNoSelectionOption()));
                    continue;
                }
                selectItems.add((SelectItem)selectItemValue);
                continue;
            }
            if (!(child instanceof UISelectItems) || (value = (uiSelectItems = (UISelectItems)child).getValue()) == null) continue;
            if (value instanceof SelectItem) {
                selectItems.add((SelectItem)value);
                continue;
            }
            if (value.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object item = Array.get(value, i);
                    if (item instanceof SelectItem) {
                        selectItems.add((SelectItem)item);
                        continue;
                    }
                    selectItems.add(this.createSelectItem(context, uiSelectItems, item));
                }
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                for (Object key : map.keySet()) {
                    selectItems.add(this.createSelectItem(context, uiSelectItems, String.valueOf(key), map.get(key)));
                }
                continue;
            }
            if (!(value instanceof Collection)) continue;
            Collection collection = (Collection)value;
            for (Object item : collection) {
                if (item instanceof SelectItem) {
                    selectItems.add((SelectItem)item);
                    continue;
                }
                selectItems.add(this.createSelectItem(context, uiSelectItems, item));
            }
        }
        return selectItems;
    }

    protected SelectItem createSelectItem(FacesContext context, UISelectItems uiSelectItems, Object object) {
        String var = (String)uiSelectItems.getAttributes().get("var");
        if (var != null) {
            context.getExternalContext().getRequestMap().put(var, object);
            Object itemLabelAsObject = uiSelectItems.getAttributes().get("itemLabel");
            Object itemValue = uiSelectItems.getAttributes().get("itemValue");
            String description = (String)uiSelectItems.getAttributes().get("itemDescription");
            Object itemDisabled = uiSelectItems.getAttributes().get("itemDisabled");
            Object itemEscaped = uiSelectItems.getAttributes().get("itemLabelEscaped");
            Object noSelection = uiSelectItems.getAttributes().get("noSelectionOption");
            if (itemValue == null) {
                itemValue = object;
            }
            String itemLabel = itemLabelAsObject == null ? String.valueOf(object) : String.valueOf(itemLabelAsObject);
            boolean disabled = itemDisabled == null ? false : Boolean.valueOf(itemDisabled.toString());
            boolean escaped = itemEscaped == null ? false : Boolean.valueOf(itemEscaped.toString());
            boolean noSelectionOption = noSelection == null ? false : Boolean.valueOf(noSelection.toString());
            return new SelectItem(itemValue, itemLabel, description, disabled, escaped, noSelectionOption);
        }
        return new SelectItem(object, String.valueOf(object));
    }

    protected SelectItem createSelectItem(FacesContext context, UISelectItems uiSelectItems, String itemLabel, Object itemValue) {
        String var = (String)uiSelectItems.getAttributes().get("var");
        if (var != null) {
            context.getExternalContext().getRequestMap().put(var, itemValue);
            String description = (String)uiSelectItems.getAttributes().get("itemDescription");
            Boolean disabled = Boolean.valueOf((String)uiSelectItems.getAttributes().get("itemDisabled"));
            Boolean escaped = Boolean.valueOf((String)uiSelectItems.getAttributes().get("itemLabelEscaped"));
            Boolean noSelectionOption = Boolean.valueOf((String)uiSelectItems.getAttributes().get("noSelectionOption"));
            return new SelectItem(itemValue, itemLabel, description, disabled.booleanValue(), escaped.booleanValue(), noSelectionOption.booleanValue());
        }
        return new SelectItem(itemValue, itemLabel);
    }

    protected String getOptionAsString(FacesContext context, UIComponent component, Converter converter, Object value) throws ConverterException {
        if (!(component instanceof ValueHolder)) {
            return value == null ? null : value.toString();
        }
        if (converter == null) {
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return (String)value;
            }
            Converter implicitConverter = this.findImplicitConverter(context, component);
            return implicitConverter == null ? value.toString() : implicitConverter.getAsString(context, component, value);
        }
        return converter.getAsString(context, component, value);
    }

    protected Converter findImplicitConverter(FacesContext context, UIComponent component) {
        Class valueType;
        ValueExpression ve = component.getValueExpression("value");
        if (ve != null && (valueType = ve.getType(context.getELContext())) != null) {
            return context.getApplication().createConverter(valueType);
        }
        return null;
    }

    protected Converter findConverter(FacesContext context, UIComponent component) {
        if (!(component instanceof ValueHolder)) {
            return null;
        }
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter != null) {
            return converter;
        }
        return this.findImplicitConverter(context, component);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Converter converter = this.findConverter(context, component);
        if (converter != null) {
            String convertableValue = submittedValue == null ? null : submittedValue.toString();
            return converter.getAsObject(context, component, convertableValue);
        }
        return submittedValue;
    }

    protected Object coerceToModelType(FacesContext ctx, Object value, Class itemValueType) {
        Object newValue;
        try {
            ExpressionFactory ef = ctx.getApplication().getExpressionFactory();
            newValue = ef.coerceToType(value, itemValueType);
        }
        catch (ELException ele) {
            newValue = value;
        }
        catch (IllegalArgumentException iae) {
            newValue = value;
        }
        return newValue;
    }

    public static boolean shouldDecode(UIComponent component) {
        boolean disabled = Boolean.valueOf(String.valueOf(component.getAttributes().get("disabled")));
        boolean readonly = Boolean.valueOf(String.valueOf(component.getAttributes().get("readonly")));
        return !disabled && !readonly;
    }
}

