/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.blockui;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.blockui.BlockUI;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class BlockUIRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        BlockUI blockUI = (BlockUI)component;
        this.encodeMarkup(context, component);
        this.encodeScript(context, blockUI);
    }

    protected void encodeScript(FacesContext context, BlockUI blockUI) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = blockUI.getClientId(context);
        String triggers = this.getTriggers(context, blockUI);
        UIComponent block = blockUI.findComponent(blockUI.getBlock());
        if (block == null) {
            throw new FacesException("Cannot find component with identifier \"" + blockUI.getBlock() + "\" in view.");
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("BlockUI", blockUI.resolveWidgetVar(), clientId, true);
        wb.attr("block", block.getClientId(context));
        wb.attr("triggers", triggers, null);
        wb.attr("blocked", blockUI.isBlocked(), false);
        this.startScript(writer, null);
        writer.write(wb.build());
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        BlockUI blockUI = (BlockUI)component;
        String clientId = blockUI.getClientId(context);
        writer.startElement("div", (UIComponent)blockUI);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)"ui-blockui-content ui-widget ui-widget-content ui-corner-all ui-helper-hidden ui-shadow", null);
        this.renderChildren(context, (UIComponent)blockUI);
        writer.endElement("div");
    }

    protected String getTriggers(FacesContext context, BlockUI blockUI) {
        String trigger = blockUI.getTrigger();
        if (trigger != null) {
            StringBuilder builder = new StringBuilder();
            String[] ids = trigger.split("[,\\s]+");
            for (int i = 0; i < ids.length; ++i) {
                String id = ids[i];
                UIComponent component = blockUI.findComponent(id);
                if (component == null) {
                    throw new FacesException("Cannot find component with identifier \"" + id + "\" in view.");
                }
                builder.append(component.getClientId(context));
                if (i >= ids.length - 1) continue;
                builder.append(",");
            }
            return builder.toString();
        }
        return null;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

