/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dialog;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dialog.Dialog;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class DialogRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        super.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Dialog dialog = (Dialog)component;
        if (dialog.isContentLoadRequest(context)) {
            this.renderChildren(context, component);
        } else {
            this.encodeMarkup(context, dialog);
            this.encodeScript(context, dialog);
        }
    }

    protected void encodeScript(FacesContext context, Dialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dialog.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("Dialog", dialog.resolveWidgetVar(), clientId, true);
        wb.attr("visible", dialog.isVisible(), false).attr("draggable", dialog.isDraggable(), true).attr("resizable", dialog.isResizable(), true).attr("modal", dialog.isModal(), false).attr("width", dialog.getWidth(), null).attr("height", dialog.getHeight(), null).attr("minWidth", dialog.getMinWidth(), Integer.MIN_VALUE).attr("minHeight", dialog.getMinHeight(), Integer.MIN_VALUE).attr("appendToBody", dialog.isAppendToBody(), false).attr("dynamic", dialog.isDynamic(), false).attr("showEffect", dialog.getShowEffect(), null).attr("hideEffect", dialog.getHideEffect(), null).attr("position", dialog.getPosition(), null).attr("closeOnEscape", dialog.isCloseOnEscape(), false).callback("onHide", "function()", dialog.getOnHide()).callback("onShow", "function()", dialog.getOnShow());
        this.encodeClientBehaviors(context, dialog, wb);
        this.startScript(writer, clientId);
        writer.write(wb.build());
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, Dialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dialog.getClientId(context);
        String style = dialog.getStyle();
        String styleClass = dialog.getStyleClass();
        String string = styleClass = styleClass == null ? "ui-dialog ui-widget ui-widget-content ui-overlay-hidden ui-corner-all ui-shadow" : "ui-dialog ui-widget ui-widget-content ui-overlay-hidden ui-corner-all ui-shadow " + styleClass;
        if (ComponentUtils.isRTL(context, dialog)) {
            styleClass = styleClass + " ui-dialog-rtl";
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (dialog.isShowHeader()) {
            this.encodeHeader(context, dialog);
        }
        this.encodeContent(context, dialog);
        this.encodeFooter(context, dialog);
        writer.endElement("div");
    }

    protected void encodeHeader(FacesContext context, Dialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String header = dialog.getHeader();
        UIComponent headerFacet = dialog.getFacet("header");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-dialog-titlebar ui-widget-header ui-helper-clearfix ui-corner-top", null);
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(dialog.getClientId(context) + "_title"), null);
        writer.writeAttribute("class", (Object)"ui-dialog-title", null);
        if (headerFacet != null) {
            headerFacet.encodeAll(context);
        } else if (header != null) {
            writer.write(header);
        }
        writer.endElement("span");
        if (dialog.isClosable()) {
            this.encodeIcon(context, "ui-dialog-titlebar-icon ui-dialog-titlebar-close ui-corner-all", "ui-icon ui-icon-closethick");
        }
        if (dialog.isMaximizable()) {
            this.encodeIcon(context, "ui-dialog-titlebar-icon ui-dialog-titlebar-maximize ui-corner-all", "ui-icon ui-icon-extlink");
        }
        if (dialog.isMinimizable()) {
            this.encodeIcon(context, "ui-dialog-titlebar-icon ui-dialog-titlebar-minimize ui-corner-all", "ui-icon ui-icon-minus");
        }
        writer.endElement("div");
    }

    protected void encodeFooter(FacesContext context, Dialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String footer = dialog.getFooter();
        UIComponent footerFacet = dialog.getFacet("footer");
        if (footer == null && footerFacet == null) {
            return;
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-dialog-footer ui-widget-content", null);
        writer.startElement("span", null);
        if (footerFacet != null) {
            footerFacet.encodeAll(context);
        } else if (footer != null) {
            writer.write(footer);
        }
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, Dialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-dialog-content ui-widget-content", null);
        if (!dialog.isDynamic()) {
            this.renderChildren(context, (UIComponent)dialog);
        }
        writer.endElement("div");
    }

    protected void encodeIcon(FacesContext context, String anchorClass, String iconClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)anchorClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("a");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

