/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.effect;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.effect.Effect;
import org.primefaces.component.effect.EffectBuilder;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class EffectRenderer
extends CoreRenderer {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Effect effect = (Effect)component;
        String clientId = effect.getClientId(context);
        String target = null;
        String source = component.getParent().getClientId(context);
        String event = effect.getEvent();
        int delay = effect.getDelay();
        if (effect.getFor() != null) {
            UIComponent _for = effect.findComponent(effect.getFor());
            if (_for == null) throw new FacesException("Cannot find component \"" + effect.getFor() + "\" in view.");
            target = _for.getClientId(context);
        } else {
            target = source;
        }
        String animation = this.getEffectBuilder(effect, target).build();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("Effect", effect.resolveWidgetVar(), clientId, true).attr("source", source).attr("event", event).attr("delay", delay).callback("fn", "function()", animation);
        this.startScript(writer, clientId);
        writer.write(wb.build());
        this.endScript(writer);
    }

    private EffectBuilder getEffectBuilder(Effect effect, String effectedComponentClientId) {
        EffectBuilder effectBuilder = new EffectBuilder(effect.getType(), effectedComponentClientId);
        for (UIComponent child : effect.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            effectBuilder.withOption(param.getName(), (String)param.getValue());
        }
        effectBuilder.atSpeed(effect.getSpeed());
        return effectBuilder;
    }
}

