/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.panel;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.Menu;
import org.primefaces.component.panel.Panel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class PanelRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String visibleParam;
        Panel panel = (Panel)component;
        String clientId = panel.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String collapsedParam = (String)params.get(clientId + "_collapsed");
        if (collapsedParam != null) {
            panel.setCollapsed(Boolean.valueOf(collapsedParam));
        }
        if ((visibleParam = (String)params.get(clientId + "_visible")) != null) {
            panel.setVisible(Boolean.valueOf(visibleParam));
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Panel panel = (Panel)component;
        this.encodeMarkup(facesContext, panel);
        this.encodeScript(facesContext, panel);
    }

    protected void encodeScript(FacesContext context, Panel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = panel.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("Panel", panel.resolveWidgetVar(), clientId, false);
        if (panel.isToggleable()) {
            wb.attr("toggleable", true).attr("toggleSpeed", panel.getToggleSpeed()).attr("collapsed", panel.isCollapsed()).attr("toggleOrientation", panel.getToggleOrientation());
        }
        if (panel.isClosable()) {
            wb.attr("closable", true).attr("closeSpeed", panel.getCloseSpeed());
        }
        if (panel.getOptionsMenu() != null) {
            wb.attr("hasMenu", true);
        }
        this.encodeClientBehaviors(context, panel, wb);
        this.startScript(writer, clientId);
        writer.write(wb.build());
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, Panel panel) throws IOException {
        String styleClass;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = panel.getClientId(context);
        Menu optionsMenu = panel.getOptionsMenu();
        boolean collapsed = panel.isCollapsed();
        boolean visible = panel.isVisible();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        String string = styleClass = panel.getStyleClass() == null ? "ui-panel ui-widget ui-widget-content ui-corner-all" : "ui-panel ui-widget ui-widget-content ui-corner-all " + panel.getStyleClass();
        if (collapsed) {
            styleClass = styleClass + " ui-hidden-container";
            if (panel.getToggleOrientation().equals("horizontal")) {
                styleClass = styleClass + " ui-panel-collapsed-h";
            }
        }
        if (!visible) {
            styleClass = styleClass + " ui-helper-hidden";
        }
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (panel.getStyle() != null) {
            writer.writeAttribute("style", (Object)panel.getStyle(), "style");
        }
        this.encodeHeader(context, panel);
        this.encodeContent(context, panel);
        this.encodeFooter(context, panel);
        if (panel.isToggleable()) {
            this.encodeStateHolder(context, panel, clientId + "_collapsed", String.valueOf(collapsed));
        }
        if (panel.isClosable()) {
            this.encodeStateHolder(context, panel, clientId + "_visible", String.valueOf(visible));
        }
        if (optionsMenu != null) {
            optionsMenu.setOverlay(true);
            optionsMenu.setTrigger(clientId + "_menu");
            optionsMenu.setMy("left top");
            optionsMenu.setAt("left bottom");
            optionsMenu.encodeAll(context);
        }
        writer.endElement("div");
    }

    protected void encodeHeader(FacesContext context, Panel panel) throws IOException {
        UIComponent actionsFacet;
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = panel.getFacet("header");
        String headerText = panel.getHeader();
        String clientId = panel.getClientId(context);
        if (headerText == null && header == null) {
            return;
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(panel.getClientId(context) + "_header"), null);
        writer.writeAttribute("class", (Object)"ui-panel-titlebar ui-widget-header ui-helper-clearfix ui-corner-all", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-panel-title", null);
        if (header != null) {
            this.renderChild(context, header);
        } else if (headerText != null) {
            writer.write(headerText);
        }
        writer.endElement("span");
        if (panel.isClosable()) {
            this.encodeIcon(context, panel, "ui-icon-closethick", clientId + "_closer", panel.getCloseTitle());
        }
        if (panel.isToggleable()) {
            String icon = panel.isCollapsed() ? "ui-icon-plusthick" : "ui-icon-minusthick";
            this.encodeIcon(context, panel, icon, clientId + "_toggler", panel.getToggleTitle());
        }
        if (panel.getOptionsMenu() != null) {
            this.encodeIcon(context, panel, "ui-icon-gear", clientId + "_menu", panel.getMenuTitle());
        }
        if ((actionsFacet = panel.getFacet("actions")) != null) {
            actionsFacet.encodeAll(context);
        }
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(panel.getClientId() + "_content"), null);
        writer.writeAttribute("class", (Object)"ui-panel-content ui-widget-content", null);
        if (panel.isCollapsed()) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        this.renderChildren(facesContext, (UIComponent)panel);
        writer.endElement("div");
    }

    protected void encodeFooter(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        UIComponent footer = panel.getFacet("footer");
        String footerText = panel.getFooter();
        if (footer != null || footerText != null) {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(panel.getClientId(facesContext) + "_footer"), null);
            writer.writeAttribute("class", (Object)"ui-panel-footer ui-widget-content", null);
            if (footer != null) {
                this.renderChild(facesContext, footer);
            } else if (footerText != null) {
                writer.write(footerText);
            }
            writer.endElement("div");
        }
    }

    protected void encodeIcon(FacesContext context, Panel panel, String iconClass, String id, String title) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        if (id != null) {
            writer.writeAttribute("id", (Object)id, null);
        }
        writer.writeAttribute("href", (Object)"javascript:void(0)", null);
        writer.writeAttribute("class", (Object)"ui-panel-titlebar-icon ui-corner-all ui-state-default", null);
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-icon " + iconClass), null);
        writer.endElement("span");
        writer.endElement("a");
    }

    protected void encodeStateHolder(FacesContext context, Panel panel, String name, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)name, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("value", (Object)value, null);
        writer.endElement("input");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

