/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.remotecommand;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.remotecommand.RemoteCommand;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.AjaxRequestBuilder;
import org.primefaces.util.ComponentUtils;

public class RemoteCommandRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        RemoteCommand command = (RemoteCommand)component;
        if (context.getExternalContext().getRequestParameterMap().containsKey(command.getClientId(context))) {
            ActionEvent event = new ActionEvent((UIComponent)command);
            if (command.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            command.queueEvent((FacesEvent)event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        RemoteCommand command;
        ResponseWriter writer = context.getResponseWriter();
        RemoteCommand source = command = (RemoteCommand)component;
        String clientId = command.getClientId(context);
        String name = command.getName();
        UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)command);
        if (form == null) {
            throw new FacesException("RemoteCommand '" + name + "'must be inside a form.");
        }
        AjaxRequestBuilder builder = new AjaxRequestBuilder();
        String request = builder.source(clientId).form(form.getClientId(context)).process(context, component, source.getProcess()).update(context, component, source.getUpdate()).async(source.isAsync()).global(source.isGlobal()).partialSubmit(source.isPartialSubmit(), command.isPartialSubmitSet()).onstart(source.getOnstart()).onerror(source.getOnerror()).onsuccess(source.getOnsuccess()).oncomplete(source.getOncomplete()).passParams().build();
        writer.startElement("script", (UIComponent)command);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(name + " = function() {");
        writer.write(request);
        writer.write("}");
        if (command.isAutoRun()) {
            writer.write(";$(function() {");
            writer.write(name + "();");
            writer.write("});");
        }
        writer.endElement("script");
    }
}

