/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tree;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tree.Tree;
import org.primefaces.component.tree.UITreeNode;
import org.primefaces.model.TreeNode;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class TreeRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Tree tree = (Tree)component;
        this.decodeSelection(context, tree);
        this.decodeBehaviors(context, (UIComponent)tree);
    }

    public void decodeSelection(FacesContext context, Tree tree) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tree.getClientId(context);
        if (tree.getSelectionMode() != null) {
            String selection = (String)params.get(clientId + "_selection");
            boolean isSingle = tree.getSelectionMode().equalsIgnoreCase("single");
            if (this.isValueBlank(selection)) {
                if (isSingle) {
                    tree.setSelection(null);
                } else {
                    tree.setSelection(new TreeNode[0]);
                }
            } else {
                String[] selectedRowKeys = selection.split(",");
                if (isSingle) {
                    tree.setRowKey(selectedRowKeys[0]);
                    tree.setSelection(tree.getRowNode());
                } else {
                    TreeNode[] selectedNodes = new TreeNode[selectedRowKeys.length];
                    for (int i = 0; i < selectedRowKeys.length; ++i) {
                        tree.setRowKey(selectedRowKeys[i]);
                        selectedNodes[i] = tree.getRowNode();
                    }
                    tree.setSelection(selectedNodes);
                }
                tree.setRowKey(null);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Tree tree = (Tree)component;
        boolean vertical = tree.getOrientation().equals("vertical");
        if (tree.isNodeExpandRequest(context)) {
            String clientId = tree.getClientId(context);
            Map params = context.getExternalContext().getRequestParameterMap();
            String rowKey = (String)params.get(clientId + "_expandNode");
            if (!vertical && rowKey.equals("root")) {
                this.encodeHorizontalTreeNodeChildren(context, tree, tree.getValue(), tree.getClientId(context), null, tree.isDynamic(), tree.isCheckboxSelection());
            } else {
                tree.setRowKey(rowKey);
                TreeNode node = tree.getRowNode();
                node.setExpanded(true);
                if (vertical) {
                    this.encodeTreeNodeChildren(context, tree, node, clientId, rowKey, tree.isDynamic(), tree.isCheckboxSelection());
                } else {
                    this.encodeHorizontalTreeNodeChildren(context, tree, node, tree.getClientId(context), rowKey, tree.isDynamic(), tree.isCheckboxSelection());
                }
                tree.setRowKey(null);
            }
        } else {
            this.encodeMarkup(context, tree);
            this.encodeScript(context, tree);
        }
    }

    protected void encodeScript(FacesContext context, Tree tree) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tree.getClientId(context);
        boolean dynamic = tree.isDynamic();
        String selectionMode = tree.getSelectionMode();
        String widget = tree.getOrientation().equals("vertical") ? "VerticalTree" : "HorizontalTree";
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('" + widget + "','" + tree.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",dynamic:" + dynamic);
        if (dynamic) {
            writer.write(",cache:" + tree.isCache());
        }
        if (selectionMode != null) {
            writer.write(",selectionMode:'" + selectionMode + "'");
            writer.write(",highlight:" + tree.isHighlight());
            writer.write(",propagateUp:" + tree.isPropagateSelectionUp());
            writer.write(",propagateDown:" + tree.isPropagateSelectionDown());
        }
        if (tree.getOnNodeClick() != null) {
            writer.write(",onNodeClick:function(node) {" + tree.getOnNodeClick() + "}");
        }
        if (tree.isAnimate()) {
            writer.write(",animate:true");
        }
        this.encodeIconStates(context, tree);
        this.encodeClientBehaviors(context, tree);
        writer.write("});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, Tree tree) throws IOException {
        boolean vertical = tree.getOrientation().equals("vertical");
        if (vertical) {
            this.encodeVerticalTree(context, tree);
        } else {
            this.encodeHorizontalTree(context, tree);
        }
    }

    public void encodeVerticalTree(FacesContext context, Tree tree) throws IOException {
        String containerClass;
        boolean checkbox;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tree.getClientId(context);
        TreeNode root = tree.getValue();
        boolean dynamic = tree.isDynamic();
        String selectionMode = tree.getSelectionMode();
        boolean selectable = selectionMode != null;
        boolean multiselectable = selectable && selectionMode.equals("single");
        boolean bl = checkbox = selectable && selectionMode.equals("checkbox");
        if (ComponentUtils.isRTL(context, tree)) {
            tree.setRTLRendering(true);
        }
        String string = containerClass = tree.isRTLRendering() ? Tree.CONTAINER_RTL_CLASS : Tree.CONTAINER_CLASS;
        if (tree.getStyleClass() != null) {
            containerClass = containerClass + " " + tree.getStyleClass();
        }
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)containerClass, null);
        writer.writeAttribute("role", (Object)"tree", null);
        writer.writeAttribute("aria-multiselectable", (Object)String.valueOf(multiselectable), null);
        if (tree.getStyle() != null) {
            writer.writeAttribute("style", (Object)tree.getStyle(), null);
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)Tree.ROOT_NODES_CLASS, null);
        if (root != null) {
            root.setExpanded(true);
            this.encodeTreeNode(context, tree, root, clientId, null, dynamic, checkbox);
        }
        writer.endElement("ul");
        if (selectable) {
            this.encodeSelectionHolder(context, tree);
        }
        writer.endElement("div");
    }

    protected void encodeHorizontalTree(FacesContext context, Tree tree) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tree.getClientId(context);
        TreeNode root = tree.getValue();
        boolean dynamic = tree.isDynamic();
        String selectionMode = tree.getSelectionMode();
        boolean checkbox = selectionMode != null && selectionMode.equals("checkbox");
        String containerClass = tree.getStyleClass() == null ? Tree.HORIZONTAL_CONTAINER_CLASS : Tree.HORIZONTAL_CONTAINER_CLASS + " " + tree.getStyleClass();
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)containerClass, null);
        writer.writeAttribute("role", (Object)"tree", null);
        if (root != null) {
            this.encodeHorizontalTreeNode(context, tree, root, clientId, null, NodeOrder.NONE, dynamic, checkbox);
        }
        if (tree.getSelectionMode() != null) {
            this.encodeSelectionHolder(context, tree);
        }
        writer.endElement("div");
    }

    protected void encodeHorizontalTreeNode(FacesContext context, Tree tree, TreeNode node, String clientId, String rowKey, NodeOrder nodeOrder, boolean dynamic, boolean checkbox) throws IOException {
        String nodeContentClass;
        String nodeClass;
        ResponseWriter writer = context.getResponseWriter();
        UITreeNode uiTreeNode = tree.getUITreeNodeByType(node.getType());
        boolean expanded = node.isExpanded();
        boolean leaf = node.isLeaf();
        boolean selectable = node.isSelectable();
        boolean selected = node.isSelected();
        if (selected) {
            tree.getSelectedRowKeys().add(rowKey);
        }
        if (leaf) {
            nodeClass = Tree.LEAF_NODE_CLASS;
        } else {
            nodeClass = Tree.PARENT_NODE_CLASS;
            nodeClass = expanded ? nodeClass + " ui-treenode-expanded" : nodeClass + " ui-treenode-collapsed";
        }
        nodeClass = selected ? nodeClass + " ui-treenode-selected" : nodeClass + " ui-treenode-unselected";
        writer.startElement("table", (UIComponent)tree);
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        if (nodeOrder != NodeOrder.NONE) {
            this.encodeConnector(context, tree, nodeOrder);
        }
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)nodeClass, null);
        writer.writeAttribute("data-nodetype", (Object)uiTreeNode.getType(), null);
        if (rowKey != null) {
            tree.setRowKey(rowKey);
            writer.writeAttribute("data-rowkey", (Object)rowKey, null);
        } else {
            context.getExternalContext().getRequestMap().put(tree.getVar(), tree.getValue().getData());
            writer.writeAttribute("data-rowkey", (Object)"root", null);
        }
        String string = nodeContentClass = node.isSelectable() ? Tree.SELECTABLE_NODE_CONTENT_CLASS_H : Tree.NODE_CONTENT_CLASS_H;
        if (selected) {
            nodeContentClass = nodeContentClass + " ui-state-highlight";
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)nodeContentClass, null);
        if (!leaf) {
            String toggleIcon = expanded ? Tree.EXPANDED_ICON_CLASS_H : Tree.COLLAPSED_ICON_CLASS_H;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)toggleIcon, null);
            writer.endElement("span");
        }
        if (checkbox && selectable) {
            this.encodeCheckbox(context, tree, node, selected);
        }
        this.encodeIcon(context, uiTreeNode, expanded);
        uiTreeNode.encodeAll(context);
        writer.endElement("div");
        writer.endElement("td");
        if (!leaf) {
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)"ui-treenode-children-container", null);
            if (!expanded) {
                writer.writeAttribute("style", (Object)"display:none", null);
            }
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)Tree.CHILDREN_NODES_CLASS, null);
            if (dynamic && expanded || !dynamic) {
                this.encodeHorizontalTreeNodeChildren(context, tree, node, clientId, rowKey, dynamic, checkbox);
            }
            writer.endElement("div");
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void encodeHorizontalTreeNodeChildren(FacesContext context, Tree tree, TreeNode node, String clientId, String rowKey, boolean dynamic, boolean checkbox) throws IOException {
        int childIndex = 0;
        Iterator<TreeNode> iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            String childRowKey = rowKey == null ? String.valueOf(childIndex) : rowKey + "_" + childIndex;
            NodeOrder no = null;
            no = node.getChildCount() == 1 ? NodeOrder.NONE : (childIndex == 0 ? NodeOrder.FIRST : (childIndex == node.getChildCount() - 1 ? NodeOrder.LAST : NodeOrder.MIDDLE));
            this.encodeHorizontalTreeNode(context, tree, iterator.next(), clientId, childRowKey, no, dynamic, checkbox);
            ++childIndex;
        }
    }

    protected void encodeConnector(FacesContext context, Tree tree, NodeOrder nodeOrder) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)"ui-treenode-connector", null);
        writer.startElement("table", null);
        writer.writeAttribute("class", (Object)"ui-treenode-connector-table", null);
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        writer.startElement("td", null);
        if (!nodeOrder.equals((Object)NodeOrder.FIRST)) {
            writer.writeAttribute("class", (Object)"ui-treenode-connector-line", null);
        }
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", null);
        writer.startElement("td", null);
        if (!nodeOrder.equals((Object)NodeOrder.LAST)) {
            writer.writeAttribute("class", (Object)"ui-treenode-connector-line", null);
        }
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("td");
    }

    public void encodeTreeNode(FacesContext context, Tree tree, TreeNode node, String clientId, String rowKey, boolean dynamic, boolean checkbox) throws IOException {
        if (rowKey != null) {
            ResponseWriter writer = context.getResponseWriter();
            tree.setRowKey(rowKey);
            boolean isLeaf = node.isLeaf();
            boolean expanded = node.isExpanded();
            boolean selectable = node.isSelectable();
            String toggleIcon = expanded ? Tree.EXPANDED_ICON_CLASS_V : (tree.isRTLRendering() ? Tree.COLLAPSED_ICON_RTL_CLASS_V : Tree.COLLAPSED_ICON_CLASS_V);
            String stateIcon = isLeaf ? Tree.LEAF_ICON_CLASS : toggleIcon;
            UITreeNode uiTreeNode = tree.getUITreeNodeByType(node.getType());
            Object datakey = tree.getDatakey();
            String nodeId = clientId + UINamingContainer.getSeparatorChar((FacesContext)context) + rowKey;
            boolean selected = node.isSelected();
            if (selected) {
                tree.getSelectedRowKeys().add(rowKey);
            }
            String containerClass = isLeaf ? Tree.LEAF_NODE_CLASS : Tree.PARENT_NODE_CLASS;
            containerClass = selected ? containerClass + " ui-treenode-selected" : containerClass + " ui-treenode-unselected";
            containerClass = uiTreeNode.getStyleClass() == null ? containerClass : containerClass + " " + uiTreeNode.getStyleClass();
            writer.startElement("li", null);
            writer.writeAttribute("id", (Object)nodeId, null);
            writer.writeAttribute("data-rowkey", (Object)rowKey, null);
            writer.writeAttribute("data-nodetype", (Object)uiTreeNode.getType(), null);
            writer.writeAttribute("class", (Object)containerClass, null);
            writer.writeAttribute("role", (Object)"treeitem", null);
            if (datakey != null) {
                writer.writeAttribute("data-datakey", datakey, null);
            }
            String contentClass = selectable ? Tree.SELECTABLE_NODE_CONTENT_CLASS_V : Tree.NODE_CONTENT_CLASS_V;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)contentClass, null);
            writer.writeAttribute("aria-expanded", (Object)String.valueOf(expanded), null);
            writer.writeAttribute("aria-selected", (Object)String.valueOf(selected), null);
            if (checkbox) {
                writer.writeAttribute("aria-checked", (Object)String.valueOf(selected), null);
            }
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)stateIcon, null);
            writer.endElement("span");
            if (checkbox && selectable) {
                this.encodeCheckbox(context, tree, node, selected);
            }
            this.encodeIcon(context, uiTreeNode, expanded);
            String nodeLabelClass = selected && !checkbox ? Tree.NODE_LABEL_CLASS + " ui-state-highlight" : Tree.NODE_LABEL_CLASS;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)nodeLabelClass, null);
            uiTreeNode.encodeAll(context);
            writer.endElement("span");
            writer.endElement("span");
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)Tree.CHILDREN_NODES_CLASS, null);
            if (!expanded) {
                writer.writeAttribute("style", (Object)"display:none", null);
            }
            if (dynamic && expanded || !dynamic) {
                this.encodeTreeNodeChildren(context, tree, node, clientId, rowKey, dynamic, checkbox);
            }
            writer.endElement("ul");
            writer.endElement("li");
        } else {
            this.encodeTreeNodeChildren(context, tree, node, clientId, rowKey, dynamic, checkbox);
        }
    }

    public void encodeTreeNodeChildren(FacesContext context, Tree tree, TreeNode node, String clientId, String rowKey, boolean dynamic, boolean checkbox) throws IOException {
        int childIndex = 0;
        Iterator<TreeNode> iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            String childRowKey = rowKey == null ? String.valueOf(childIndex) : rowKey + "_" + childIndex;
            this.encodeTreeNode(context, tree, iterator.next(), clientId, childRowKey, dynamic, checkbox);
            ++childIndex;
        }
    }

    protected void encodeIconStates(FacesContext context, Tree tree) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map<String, UITreeNode> nodes = tree.getTreeNodes();
        writer.write(",iconStates:{");
        boolean firstWritten = false;
        for (String type : nodes.keySet()) {
            UITreeNode node = nodes.get(type);
            String expandedIcon = node.getExpandedIcon();
            String collapsedIcon = node.getCollapsedIcon();
            if (expandedIcon == null || collapsedIcon == null) continue;
            if (firstWritten) {
                writer.write(",");
            }
            writer.write("'" + node.getType() + "' : {");
            writer.write("expandedIcon:'" + expandedIcon + "'");
            writer.write(",collapsedIcon:'" + collapsedIcon + "'");
            writer.write("}");
            firstWritten = true;
        }
        writer.write("}");
    }

    protected void encodeIcon(FacesContext context, UITreeNode uiTreeNode, boolean expanded) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        String icon = uiTreeNode.getIconToRender(expanded);
        if (icon != null) {
            writer.writeAttribute("class", (Object)(Tree.NODE_ICON_CLASS + " " + icon), null);
        }
        writer.endElement("span");
    }

    protected void encodeSelectionHolder(FacesContext context, Tree tree) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = tree.getClientId(context) + "_selection";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("value", (Object)tree.getSelectedRowKeysAsString(), null);
        writer.endElement("input");
    }

    protected void encodeCheckbox(FacesContext context, Tree tree, TreeNode node, boolean selected) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String iconClass = selected ? "ui-chkbox-icon ui-icon ui-icon-check ui-c" : "ui-chkbox-icon ui-c";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-chkbox ui-widget", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-chkbox-box ui-widget ui-corner-all ui-state-default", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum NodeOrder {
        FIRST,
        MIDDLE,
        LAST,
        NONE;

    }
}

