/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

public class WidgetBuilder {
    protected StringBuilder buffer = new StringBuilder();
    protected boolean onload = false;
    protected String resourcePath = null;

    public WidgetBuilder widget(String widgetClass, String widgetVar, String id, boolean onload) {
        this.onload = onload;
        if (this.onload) {
            this.buffer.append("$(function(){");
        }
        this.buffer.append("PrimeFaces.cw('").append(widgetClass).append("','").append(widgetVar).append("',{");
        this.buffer.append("id:'").append(id).append("'");
        return this;
    }

    public WidgetBuilder widget(String widgetClass, String widgetVar, String id, String resourcePath, boolean onload) {
        this.widget(widgetClass, widgetVar, id, onload);
        this.resourcePath = resourcePath;
        return this;
    }

    public WidgetBuilder attr(String name, String value) {
        this.buffer.append(",").append(name).append(":'").append(value).append("'");
        return this;
    }

    public WidgetBuilder nativeAttr(String name, String value) {
        this.buffer.append(",").append(name).append(":").append(value);
        return this;
    }

    public WidgetBuilder attr(String name, boolean value) {
        this.buffer.append(",").append(name).append(":").append(value);
        return this;
    }

    public WidgetBuilder attr(String name, Number value) {
        this.buffer.append(",").append(name).append(":").append(value);
        return this;
    }

    public WidgetBuilder attr(String name, String value, String defaultValue) {
        if (value != null && !value.equals(defaultValue)) {
            this.buffer.append(",").append(name).append(":'").append(value).append("'");
        }
        return this;
    }

    public WidgetBuilder attr(String name, double value, double defaultValue) {
        if (value != defaultValue) {
            this.buffer.append(",").append(name).append(":").append(value);
        }
        return this;
    }

    public WidgetBuilder attr(String name, int value, int defaultValue) {
        if (value != defaultValue) {
            this.buffer.append(",").append(name).append(":").append(value);
        }
        return this;
    }

    public WidgetBuilder attr(String name, boolean value, boolean defaultValue) {
        if (value != defaultValue) {
            this.buffer.append(",").append(name).append(":").append(value);
        }
        return this;
    }

    public WidgetBuilder callback(String name, String signature, String callback) {
        if (callback != null) {
            this.buffer.append(",").append(name).append(":").append(signature).append("{").append(callback).append("}");
        }
        return this;
    }

    public WidgetBuilder append(String str) {
        this.buffer.append(str);
        return this;
    }

    public WidgetBuilder append(Number number) {
        this.buffer.append(number);
        return this;
    }

    public String build() {
        this.buffer.append("}");
        if (this.resourcePath != null) {
            this.buffer.append(",'").append(this.resourcePath).append("'");
        }
        this.buffer.append(");");
        if (this.onload) {
            this.buffer.append("});");
        }
        String script = this.buffer.toString();
        this.reset();
        return script;
    }

    public void reset() {
        this.buffer.setLength(0);
        this.onload = false;
        this.resourcePath = null;
    }
}

