package beans;

import java.util.ArrayList;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.ServletContext;

import bbdd.BaseDeDatos;

@ManagedBean(name="datosBean")
@SessionScoped
public class Encuesta {
	
	private ArrayList<DatosProgramaLavado> datos;
	private Usuario user;
	
	public Encuesta(){
		datos=new ArrayList<DatosProgramaLavado>();
		user=new Usuario();
		for(int i=0;i<3;i++){
			DatosProgramaLavado aux=new DatosProgramaLavado();
			aux.setProgram(Program.ECO);
			datos.add(aux);
		}
		for(int i=0;i<3;i++){
			DatosProgramaLavado aux=new DatosProgramaLavado();
			aux.setProgram(Program.INTENSIVE);
			datos.add(aux);
		}
		for(int i=0;i<3;i++){
			DatosProgramaLavado aux=new DatosProgramaLavado();
			aux.setProgram(Program.QUICK);
			datos.add(aux);
		}
		for(int i=0;i<3;i++){
			DatosProgramaLavado aux=new DatosProgramaLavado();
			aux.setProgram(Program.GLASS_CARE);
			datos.add(aux);
		}
		for(int i=0;i<3;i++){
			DatosProgramaLavado aux=new DatosProgramaLavado();
			aux.setProgram(Program.HYGIENE);
			datos.add(aux);
		}
		for(int i=0;i<3;i++){
			DatosProgramaLavado aux=new DatosProgramaLavado();
			aux.setProgram(Program.PREWASHING);
			datos.add(aux);
		}
	}
	
	
	
	public Usuario getUser() {
		return user;
	}



	public void setUser(Usuario user) {
		this.user = user;
	}



	public ArrayList<DatosProgramaLavado> getDatos() {
		return datos;
	}

	public void setDatos(ArrayList<DatosProgramaLavado> datos) {
		this.datos = datos;
	}

	
	
	public SelectItem[] getTypeLoad() {
	    SelectItem[] items = new SelectItem[TypeLoad.values().length];
	    int i = 0;
	    for(TypeLoad g: TypeLoad.values()) {
	      items[i++] = new SelectItem(g,g.getLabel());
	    }
	    return items;
	  }
	
	public SelectItem[] getSoil() {
	    SelectItem[] items = new SelectItem[Soil.values().length];
	    int i = 0;
	    for(Soil g: Soil.values()) {
	      items[i++] = new SelectItem(g,g.getLabel());
	    }
	    return items;
	  }
	
	
	public SelectItem[] getLoad() {
	    SelectItem[] items = new SelectItem[Load.values().length];
	    int i = 0;
	    for(Load g: Load.values()) {
	      items[i++] = new SelectItem(g,g.getLabel());
	    }
	    return items;
	  }
	
	
	public void guardarDatos(){
		
		BaseDeDatos bbdd=new BaseDeDatos("sands","sands-datos","sands");
		bbdd.conectar();
		int user=bbdd.nuevoUsuario(this.user);
		bbdd.nuevoDatosPrograma(this.datos,user);
		bbdd.desconectar();
		
		FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
		
		String ctxPath =((ServletContext) externalContext.getContext()).getContextPath();
        
		try{
        externalContext.redirect(ctxPath + "/fin.jsf");
		}
		catch(Exception e){
			
		}
		
	}
	
	public void siguiente_1(){
		
		for(int i=0;i<9;i++){
			DatosProgramaLavado aux=datos.get(i);
			if(aux.getProgram()==Program.ECO){
				if(aux.getType()!=null && aux.getSoil()!=null && aux.getLoad()!=null && aux.getUse()==0)aux.setUse(datos.get(0).getUse());
			}
			if(aux.getProgram()==Program.INTENSIVE){
				if(aux.getType()!=null && aux.getSoil()!=null && aux.getLoad()!=null && aux.getUse()==0)aux.setUse(datos.get(3).getUse());
			}
			if(aux.getProgram()==Program.QUICK){
				if(aux.getType()!=null && aux.getSoil()!=null && aux.getLoad()!=null && aux.getUse()==0)aux.setUse(datos.get(6).getUse());
			}
		}
		
		FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
		
		String ctxPath =((ServletContext) externalContext.getContext()).getContextPath();
        
		try{
        externalContext.redirect(ctxPath + "/formulario_b.jsf");
		}
		catch(Exception e){
			
		}
		
	}
	
	public void siguiente_2(){
		
		for(int i=9;i<18;i++){
			DatosProgramaLavado aux=datos.get(i);
			if(aux.getProgram()==Program.GLASS_CARE){
				if(aux.getType()!=null && aux.getSoil()!=null && aux.getLoad()!=null && aux.getUse()==0)aux.setUse(datos.get(9).getUse());
			}
			if(aux.getProgram()==Program.HYGIENE){
				if(aux.getType()!=null && aux.getSoil()!=null && aux.getLoad()!=null && aux.getUse()==0)aux.setUse(datos.get(12).getUse());
			}
			if(aux.getProgram()==Program.PREWASHING){
				if(aux.getType()!=null && aux.getSoil()!=null && aux.getLoad()!=null && aux.getUse()==0)aux.setUse(datos.get(15).getUse());
			}
		}
		
		FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
		
		String ctxPath =((ServletContext) externalContext.getContext()).getContextPath();
        
		try{
        externalContext.redirect(ctxPath + "/formulario_c.jsf");
		}
		catch(Exception e){
			
		}
		
	}
	

}
