/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.casebase;

import java.util.ArrayList;
import java.util.Collection;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CaseBaseFilter;
import jcolibri.cbrcore.Connector;
import jcolibri.exception.InitializingException;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedLinealCaseBase
implements CBRCaseBase {
    private Connector connector;
    private Collection<CBRCase> originalCases;
    private Collection<CBRCase> workingCases;

    @Override
    public void close() {
        ArrayList<CBRCase> casestoRemove = new ArrayList<CBRCase>(this.originalCases);
        casestoRemove.removeAll(this.workingCases);
        LogFactory.getLog(this.getClass()).info((Object)("Deleting " + casestoRemove.size() + " cases from storage media"));
        this.connector.deleteCases(casestoRemove);
        ArrayList<CBRCase> casestoStore = new ArrayList<CBRCase>(this.workingCases);
        casestoStore.removeAll(this.originalCases);
        LogFactory.getLog(this.getClass()).info((Object)("Storing " + casestoStore.size() + " cases into storage media"));
        this.connector.storeCases(casestoStore);
        this.connector.close();
    }

    @Override
    public void forgetCases(Collection<CBRCase> cases) {
        this.workingCases.removeAll(cases);
    }

    @Override
    public Collection<CBRCase> getCases() {
        return this.workingCases;
    }

    @Override
    public Collection<CBRCase> getCases(CaseBaseFilter filter) {
        return null;
    }

    @Override
    public void init(Connector connector) throws InitializingException {
        this.connector = connector;
        this.originalCases = this.connector.retrieveAllCases();
        this.workingCases = new ArrayList<CBRCase>(this.originalCases);
    }

    @Override
    public void learnCases(Collection<CBRCase> cases) {
        this.workingCases.addAll(cases);
    }
}

