/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.maintenance_evaluation.evaluators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import jcolibri.casebase.CachedLinealCaseBase;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.extensions.maintenance_evaluation.MaintenanceEvaluator;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaintenanceNFoldEvaluator
extends MaintenanceEvaluator {
    public void NFoldEvaluation(int numFolds, int repetitions) {
        try {
            long t = new Date().getTime();
            int numberOfCycles = 0;
            LogFactory.getLog(this.getClass()).info((Object)"Running precycle()");
            CBRCaseBase caseBase = this.app.preCycle();
            if (!(caseBase instanceof CachedLinealCaseBase)) {
                LogFactory.getLog(this.getClass()).warn((Object)"Evaluation should be executed using a cached case base");
            }
            ArrayList<CBRCase> cases = new ArrayList<CBRCase>(caseBase.getCases());
            int r = 0;
            while (r < repetitions) {
                ArrayList<ArrayList<CBRCase>> folds = this.createFolds(cases, numFolds);
                int f = 0;
                while (f < numFolds) {
                    ArrayList<CBRCase> querySet = new ArrayList<CBRCase>();
                    this.prepareCases(cases, querySet, f, caseBase, folds);
                    for (CBRCase c : querySet) {
                        LogFactory.getLog(this.getClass()).info((Object)("Running cycle() " + numberOfCycles));
                        this.app.cycle(c);
                        ++numberOfCycles;
                    }
                    ++f;
                }
                ++r;
            }
            caseBase.forgetCases(cases);
            caseBase.learnCases(cases);
            LogFactory.getLog(this.getClass()).info((Object)"Running postcycle()");
            this.app.postCycle();
            report.setTotalTime(t);
            report.setNumberOfCycles(numberOfCycles);
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    protected void prepareCases(Collection<CBRCase> originalCases, List<CBRCase> querySet, int fold, CBRCaseBase caseBase, ArrayList<ArrayList<CBRCase>> folds) {
        ArrayList<CBRCase> caseBaseSet = new ArrayList<CBRCase>();
        MaintenanceNFoldEvaluator.getFolds(fold, querySet, caseBaseSet, folds);
        caseBase.forgetCases(originalCases);
        caseBase.learnCases(caseBaseSet);
        if (this.simConfig != null && this.editMethod != null) {
            this.editCaseBase(caseBase);
        }
    }

    protected ArrayList<ArrayList<CBRCase>> createFolds(Collection<CBRCase> cases, int numFolds) {
        ArrayList<ArrayList<CBRCase>> folds = new ArrayList<ArrayList<CBRCase>>();
        int foldsize = cases.size() / numFolds;
        ArrayList<CBRCase> copy = new ArrayList<CBRCase>(cases);
        int f = 0;
        while (f < numFolds) {
            ArrayList<CBRCase> fold = new ArrayList<CBRCase>();
            int i = 0;
            while (i < foldsize && copy.size() > 0) {
                int random = (int)(Math.random() * (double)copy.size());
                CBRCase _case = copy.get(random);
                copy.remove(random);
                fold.add(_case);
                ++i;
            }
            folds.add(fold);
            ++f;
        }
        return folds;
    }

    public static void getFolds(int f, List<CBRCase> querySet, List<CBRCase> caseBaseSet, ArrayList<ArrayList<CBRCase>> folds) {
        querySet.clear();
        caseBaseSet.clear();
        querySet.addAll((Collection<CBRCase>)folds.get(f));
        int i = 0;
        while (i < folds.size()) {
            if (i != f) {
                caseBaseSet.addAll((Collection<CBRCase>)folds.get(i));
            }
            ++i;
        }
    }
}

