/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.maintenance_evaluation.evaluators;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import jcolibri.casebase.CachedLinealCaseBase;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.extensions.maintenance_evaluation.MaintenanceEvaluator;
import jcolibri.util.FileIO;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaintenanceSameSplitEvaluator
extends MaintenanceEvaluator {
    public void HoldOutfromFile(String file) {
        try {
            long t = new Date().getTime();
            int numberOfCycles = 0;
            LogFactory.getLog(this.getClass()).info((Object)"Running precycle()");
            CBRCaseBase caseBase = this.app.preCycle();
            if (!(caseBase instanceof CachedLinealCaseBase)) {
                LogFactory.getLog(this.getClass()).warn((Object)"Evaluation should be executed using a cached case base");
            }
            ArrayList<CBRCase> originalCases = new ArrayList<CBRCase>(caseBase.getCases());
            ArrayList<CBRCase> querySet = new ArrayList<CBRCase>();
            this.prepareCases(originalCases, querySet, file, caseBase);
            int totalSteps = querySet.size();
            ProgressController.init(this.getClass(), "Same Split - Hold Out Evaluation", totalSteps);
            for (CBRCase c : querySet) {
                LogFactory.getLog(this.getClass()).info((Object)("Running cycle() " + numberOfCycles));
                this.app.cycle(c);
                ProgressController.step(this.getClass());
                ++numberOfCycles;
            }
            ProgressController.finish(this.getClass());
            caseBase.forgetCases(originalCases);
            caseBase.learnCases(originalCases);
            LogFactory.getLog(this.getClass()).info((Object)"Running postcycle()");
            this.app.postCycle();
            t = new Date().getTime() - t;
            report.setTotalTime(t);
            report.setNumberOfCycles(numberOfCycles);
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    protected void prepareCases(Collection<CBRCase> originalCases, List<CBRCase> querySet, String file, CBRCaseBase caseBase) {
        ArrayList<CBRCase> caseBaseSet = new ArrayList<CBRCase>();
        MaintenanceSameSplitEvaluator.splitCaseBaseFromFile(originalCases, querySet, caseBaseSet, file);
        caseBase.forgetCases(originalCases);
        caseBase.learnCases(caseBaseSet);
        if (this.simConfig != null && this.editMethod != null) {
            this.editCaseBase(caseBase);
        }
    }

    public static void splitCaseBaseFromFile(Collection<CBRCase> wholeCaseBase, List<CBRCase> querySet, List<CBRCase> casebaseSet, String filename) {
        querySet.clear();
        casebaseSet.clear();
        casebaseSet.addAll(wholeCaseBase);
        try {
            BufferedReader br = null;
            br = new BufferedReader(new FileReader(FileIO.findFile(filename).getFile()));
            if (br == null) {
                throw new Exception("Error opening file: " + filename);
            }
            String line = "";
            while ((line = br.readLine()) != null) {
                CBRCase c = null;
                int pos = 0;
                boolean found = false;
                Iterator<CBRCase> iter = casebaseSet.iterator();
                while (iter.hasNext() && !found) {
                    c = iter.next();
                    if (c.getID().toString().equals(line)) {
                        found = true;
                        continue;
                    }
                    ++pos;
                }
                if (c == null) {
                    System.out.println("Case " + line + " not found into case base");
                    continue;
                }
                casebaseSet.remove(pos);
                querySet.add(c);
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

