/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.recommendation.navigationByAsking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.recommendation.navigationByAsking.SelectAttributeMethod;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.util.AttributeUtils;
import jcolibri.util.CopyUtils;
import jcolibri.util.ProgressController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimilarityInfluence
implements SelectAttributeMethod {
    private static ArrayList<Attribute> asked;
    private NNConfig simConfig;

    public static Attribute getMoreSimVarAttribute(Collection<CBRCase> cases, CBRQuery query, NNConfig simConfig, boolean init) throws ExecutionException {
        if (init) {
            asked = new ArrayList();
        }
        if (asked == null) {
            throw new ExecutionException("Similarity Influence method must be initialized each cycle");
        }
        CBRCase acase = cases.iterator().next();
        Collection<Attribute> atts = AttributeUtils.getAttributes(acase.getDescription());
        atts.remove(acase.getDescription().getIdAttribute());
        atts.removeAll(asked);
        if (atts.isEmpty()) {
            asked = new ArrayList();
            atts = AttributeUtils.getAttributes(acase.getDescription());
        }
        ProgressController.init(SimilarityInfluence.class, "Similarity Influence selection", -1);
        System.out.println("Computing SimVar for " + cases.size() + " cases");
        double maxSimVar = 0.0;
        Attribute maxSimVaratt = null;
        for (Attribute a : atts) {
            double simVar = SimilarityInfluence.computeSimVar(a, cases, query, simConfig);
            System.out.println("SimVar(" + a.getName() + ") = " + simVar);
            if (!(simVar > maxSimVar)) continue;
            maxSimVar = simVar;
            maxSimVaratt = a;
        }
        ProgressController.finish(SimilarityInfluence.class);
        asked.add(maxSimVaratt);
        return maxSimVaratt;
    }

    private static double computeSimVar(Attribute a, Collection<CBRCase> cases, CBRQuery query, NNConfig simConfig) {
        double Csize = cases.size();
        Hashtable<Object, HashSet<CBRCase>> clases = new Hashtable<Object, HashSet<CBRCase>>();
        for (CBRCase c : cases) {
            Object value = AttributeUtils.findValue(a, c.getDescription());
            HashSet<CBRCase> set = (HashSet<CBRCase>)clases.get(value);
            if (set == null) {
                set = new HashSet<CBRCase>();
                clases.put(value, set);
            }
            set.add(c);
        }
        int i = 0;
        double simVar = 0.0;
        for (Object v : clases.keySet()) {
            double pv = (double)((HashSet)clases.get(v)).size() / Csize;
            CBRQuery newQuery = new CBRQuery();
            newQuery.setDescription(CopyUtils.copyCaseComponent(query.getDescription()));
            AttributeUtils.setValue(a, newQuery, v);
            double var = SimilarityInfluence.computeVar(newQuery, cases, simConfig);
            simVar += pv * var;
            ++i;
            ProgressController.step(SimilarityInfluence.class);
        }
        return simVar;
    }

    private static double computeVar(CBRQuery query, Collection<CBRCase> cases, NNConfig simConfig) {
        Collection<RetrievalResult> sim = NNScoringMethod.evaluateSimilarity(cases, query, simConfig);
        double niu = 0.0;
        for (RetrievalResult rr : sim) {
            niu += rr.getEval();
        }
        niu /= (double)sim.size();
        double res = 0.0;
        for (RetrievalResult rr : sim) {
            res += (rr.getEval() - niu) * (rr.getEval() - niu);
        }
        return res / (double)cases.size();
    }

    public SimilarityInfluence(NNConfig simConfig) {
        this.simConfig = simConfig;
    }

    @Override
    public Attribute getAttribute(Collection<CBRCase> cases, CBRQuery query) throws ExecutionException {
        return SimilarityInfluence.getMoreSimVarAttribute(cases, query, this.simConfig, false);
    }
}

