/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE.common;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.extensions.textual.IE.IEutils;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.extensions.textual.IE.representation.info.FeatureInfo;
import jcolibri.extensions.textual.IE.representation.info.PhraseInfo;
import jcolibri.util.AttributeUtils;
import jcolibri.util.FileIO;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainTopicClassifier {
    static ArrayList<TopicRule> topicsRules;

    public static void classifyWithTopic(Collection<CBRCase> cases, Collection<Attribute> attributes) {
        LogFactory.getLog(DomainTopicClassifier.class).info((Object)"Classifying with topic.");
        ProgressController.init(DomainTopicClassifier.class, "Classifying with topic  ...", cases.size());
        for (CBRCase c : cases) {
            for (Attribute a : attributes) {
                Object o = AttributeUtils.findValue(a, c);
                DomainTopicClassifier.classifyWithTopic((IEText)o);
            }
            ProgressController.step(DomainTopicClassifier.class);
        }
        ProgressController.finish(DomainTopicClassifier.class);
    }

    public static void classifyWithTopic(CBRQuery query, Collection<Attribute> attributes) {
        LogFactory.getLog(DomainTopicClassifier.class).info((Object)"Classifying with topic.");
        for (Attribute a : attributes) {
            Object o = AttributeUtils.findValue(a, query);
            DomainTopicClassifier.classifyWithTopic((IEText)o);
        }
    }

    public static void classifyWithTopic(Collection<CBRCase> cases) {
        LogFactory.getLog(DomainTopicClassifier.class).info((Object)"Classifying with topic.");
        ProgressController.init(DomainTopicClassifier.class, "Classifying with topic  ...", cases.size());
        for (CBRCase c : cases) {
            Collection<IEText> texts = IEutils.getTexts(c);
            for (IEText t : texts) {
                DomainTopicClassifier.classifyWithTopic(t);
            }
            ProgressController.step(DomainTopicClassifier.class);
        }
        ProgressController.finish(DomainTopicClassifier.class);
    }

    public static void classifyWithTopic(CBRQuery query) {
        LogFactory.getLog(DomainTopicClassifier.class).info((Object)"Classifying with topic.");
        Collection<IEText> texts = IEutils.getTexts(query);
        for (IEText t : texts) {
            DomainTopicClassifier.classifyWithTopic(t);
        }
    }

    public static void classifyWithTopic(IEText text) {
        List<PhraseInfo> _phrases = text.getPhrases();
        List<FeatureInfo> _features = text.getFeatures();
        for (TopicRule rule : topicsRules) {
            boolean valid = true;
            HashMap<String, String> conditions = rule._data;
            Iterator<String> fOpIter = conditions.keySet().iterator();
            while (fOpIter.hasNext() && valid) {
                Iterator it;
                boolean found;
                String featureOrPhrase = fOpIter.next();
                String value = conditions.get(featureOrPhrase);
                if (value == null) {
                    found = false;
                    it = _phrases.iterator();
                    while (it.hasNext() && !found) {
                        PhraseInfo pi = (PhraseInfo)it.next();
                        if (!pi.getPhrase().equals(featureOrPhrase)) continue;
                        found = true;
                    }
                    valid = found;
                    continue;
                }
                found = false;
                it = _features.iterator();
                while (it.hasNext() && !found) {
                    FeatureInfo fi = (FeatureInfo)it.next();
                    found = !value.equals("?") ? fi.getFeature().equals(featureOrPhrase) && fi.getValue().equals(value) : fi.getFeature().equals(featureOrPhrase);
                }
                valid = found;
            }
            if (!valid) continue;
            text.addTopic(rule._name);
        }
    }

    public static void loadRules(String filename) {
        try {
            topicsRules = new ArrayList();
            URL file = FileIO.findFile(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(file.openStream()));
            String line = "";
            while ((line = br.readLine()) != null) {
                int indexClose;
                int indexOpen;
                if (line.startsWith("#")) continue;
                int pos = line.indexOf(93);
                if (pos == -1) {
                    throw new Exception(String.valueOf(line) + "  Topic field not found");
                }
                String _feature = line.substring(1, pos);
                String _rest = line.substring(pos + 1);
                HashMap<String, String> data = new HashMap<String, String>();
                while ((indexOpen = _rest.indexOf("<")) != -1 && (indexClose = _rest.indexOf(">")) != -1) {
                    String content = _rest.substring(indexOpen, indexClose);
                    StringTokenizer st = new StringTokenizer(content, "<,>");
                    if (!st.hasMoreTokens()) continue;
                    String featureOrPhrase = st.nextToken();
                    String value = null;
                    if (st.hasMoreTokens()) {
                        value = st.nextToken();
                    }
                    data.put(DomainTopicClassifier.cleanSpaces(featureOrPhrase), DomainTopicClassifier.cleanSpaces(value));
                    _rest = _rest.substring(indexClose + 1, _rest.length());
                }
                TopicRule rule = new TopicRule(_feature, data);
                topicsRules.add(rule);
            }
            br.close();
        }
        catch (Exception e) {
            LogFactory.getLog(DomainTopicClassifier.class).error((Object)e);
        }
    }

    private static String cleanSpaces(String w) {
        if (w == null) {
            return null;
        }
        String res = "";
        StringTokenizer st = new StringTokenizer(w, " ");
        while (st.hasMoreTokens()) {
            res = String.valueOf(res) + st.nextToken();
            if (!st.hasMoreTokens()) continue;
            res = String.valueOf(res) + " ";
        }
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TopicRule {
        String _name;
        HashMap<String, String> _data;

        TopicRule(String n, HashMap<String, String> d) {
            this._name = n;
            this._data = d;
        }
    }
}

