/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE.common;

import java.util.Collection;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.extensions.textual.IE.IEutils;
import jcolibri.extensions.textual.IE.gate.GatePhrasesExtractor;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.extensions.textual.IE.representation.Token;
import jcolibri.extensions.textual.stemmer.Stemmer;
import jcolibri.util.AttributeUtils;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextStemmer {
    static Stemmer stemmer = new Stemmer();

    public static void stem(Collection<CBRCase> cases, Collection<Attribute> attributes) {
        LogFactory.getLog(TextStemmer.class).info((Object)"Stemming text.");
        ProgressController.init(TextStemmer.class, "Stemming text...", cases.size());
        for (CBRCase c : cases) {
            for (Attribute a : attributes) {
                Object o = AttributeUtils.findValue(a, c);
                TextStemmer.stem((IEText)o);
            }
            ProgressController.step(GatePhrasesExtractor.class);
        }
        ProgressController.finish(GatePhrasesExtractor.class);
    }

    public static void stem(CBRQuery query, Collection<Attribute> attributes) {
        LogFactory.getLog(TextStemmer.class).info((Object)"Stemming text.");
        for (Attribute a : attributes) {
            Object o = AttributeUtils.findValue(a, query);
            TextStemmer.stem((IEText)o);
        }
    }

    public static void stem(Collection<CBRCase> cases) {
        LogFactory.getLog(TextStemmer.class).info((Object)"Stemming text.");
        ProgressController.init(TextStemmer.class, "Stemming text...", cases.size());
        for (CBRCase c : cases) {
            Collection<IEText> texts = IEutils.getTexts(c);
            for (IEText t : texts) {
                TextStemmer.stem(t);
            }
            ProgressController.step(GatePhrasesExtractor.class);
        }
        ProgressController.finish(GatePhrasesExtractor.class);
    }

    public static void stem(CBRQuery query) {
        LogFactory.getLog(TextStemmer.class).info((Object)"Stemming text.");
        Collection<IEText> texts = IEutils.getTexts(query);
        for (IEText t : texts) {
            TextStemmer.stem(t);
        }
    }

    public static void stem(IEText text) {
        for (Token t : text.getAllTokens()) {
            if (t.isStopWord()) continue;
            String stem = stemmer.stem(t.getRawContent());
            if (stem == null) {
                stem = t.getRawContent();
            }
            t.setStem(stem);
        }
    }
}

