/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE.opennlp;

import java.util.Hashtable;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.extensions.textual.IE.representation.Paragraph;
import jcolibri.extensions.textual.IE.representation.Sentence;
import jcolibri.extensions.textual.IE.representation.Token;
import opennlp.common.xml.NLPDocument;
import opennlp.common.xml.NLPDocumentBuilder;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;

public class IETextOpenNLP
extends IEText {
    protected NLPDocument doc;
    private Hashtable<Paragraph, Element> parMapping = new Hashtable();
    private Hashtable<Sentence, Element> sentMapping = new Hashtable();
    private Hashtable<Token, Element> tokMapping = new Hashtable();

    public IETextOpenNLP() {
    }

    public IETextOpenNLP(String content) {
        try {
            this.fromString(content);
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    public void fromString(String content) throws Exception {
        super.fromString(content);
        NLPDocumentBuilder builder = new NLPDocumentBuilder();
        this.doc = builder.build(content);
    }

    public NLPDocument getDocument() {
        return this.doc;
    }

    protected Element getParagraphMapping(Paragraph par) {
        return this.parMapping.get(par);
    }

    protected void setParagraphMapping(Paragraph par, Element annot) {
        this.parMapping.put(par, annot);
    }

    protected Element getSentenceMapping(Sentence sent) {
        return this.sentMapping.get(sent);
    }

    protected void setSentenceMapping(Sentence sent, Element annot) {
        this.sentMapping.put(sent, annot);
    }

    protected Element getTokenMapping(Token tok) {
        return this.tokMapping.get(tok);
    }

    protected void setTokenMapping(Token tok, Element annot) {
        this.tokMapping.put(tok, annot);
    }
}

