/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE.opennlp;

import java.util.Collection;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.extensions.textual.IE.IEutils;
import jcolibri.extensions.textual.IE.opennlp.IETextOpenNLP;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.extensions.textual.IE.representation.Token;
import jcolibri.util.AttributeUtils;
import jcolibri.util.ProgressController;
import opennlp.grok.preprocess.postag.EnglishPOSTaggerME;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpennlpPOStagger {
    private static EnglishPOSTaggerME englishPOStagger = null;

    public static void tag(Collection<CBRCase> cases, Collection<Attribute> attributes) {
        LogFactory.getLog(OpennlpPOStagger.class).info((Object)"OpenNLP POS tagging.");
        ProgressController.init(OpennlpPOStagger.class, "OpenNLP POS tagging", cases.size());
        for (CBRCase c : cases) {
            for (Attribute a : attributes) {
                Object o = AttributeUtils.findValue(a, c);
                if (!(o instanceof IETextOpenNLP)) continue;
                OpennlpPOStagger.tag((IETextOpenNLP)o);
            }
            ProgressController.step(OpennlpPOStagger.class);
        }
        ProgressController.finish(OpennlpPOStagger.class);
    }

    public static void tag(CBRQuery query, Collection<Attribute> attributes) {
        LogFactory.getLog(OpennlpPOStagger.class).info((Object)"OpenNLP POS tagging.");
        for (Attribute a : attributes) {
            Object o = AttributeUtils.findValue(a, query);
            if (!(o instanceof IETextOpenNLP)) continue;
            OpennlpPOStagger.tag((IETextOpenNLP)o);
        }
    }

    public static void tag(Collection<CBRCase> cases) {
        LogFactory.getLog(OpennlpPOStagger.class).info((Object)"OpenNLP POS tagging.");
        ProgressController.init(OpennlpPOStagger.class, "OpenNLP POS tagging", cases.size());
        for (CBRCase c : cases) {
            Collection<IEText> texts = IEutils.getTexts(c);
            for (IEText t : texts) {
                if (!(t instanceof IETextOpenNLP)) continue;
                OpennlpPOStagger.tag((IETextOpenNLP)t);
            }
            ProgressController.step(OpennlpPOStagger.class);
        }
        ProgressController.finish(OpennlpPOStagger.class);
    }

    public static void tag(CBRQuery query) {
        LogFactory.getLog(OpennlpPOStagger.class).info((Object)"OpenNLP POS tagging.");
        Collection<IEText> texts = IEutils.getTexts(query);
        for (IEText t : texts) {
            if (!(t instanceof IETextOpenNLP)) continue;
            OpennlpPOStagger.tag((IETextOpenNLP)t);
        }
    }

    public static void tag(IETextOpenNLP text) {
        EnglishPOSTaggerME tagger = OpennlpPOStagger.getSentenceDetector();
        tagger.process(text.getDocument());
        for (Token t : text.getAllTokens()) {
            Element elem = text.getTokenMapping(t);
            Element word = elem.getChild("w");
            String posTag = word.getAttributeValue("pos");
            t.setPostag(posTag);
        }
    }

    private static EnglishPOSTaggerME getSentenceDetector() {
        if (englishPOStagger == null) {
            englishPOStagger = new EnglishPOSTaggerME();
        }
        return englishPOStagger;
    }
}

