/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.gui.editors;

import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import jcolibri.method.gui.editors.ParameterEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanEditor
extends JComboBox
implements ParameterEditor {
    private static final long serialVersionUID = 1L;
    private final String ANY = "<any>";
    private final String TRUE = "true";
    private final String FALSE = "false";

    public BooleanEditor() {
        this.addItem("<any>");
        this.addItem("true");
        this.addItem("false");
    }

    @Override
    public Object getEditorValue() {
        if (this.getSelectedItem().equals("<any>")) {
            return null;
        }
        if (this.getSelectedItem().equals("true")) {
            return true;
        }
        return false;
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public void setEditorValue(Object value) {
        if (value == null) {
            this.setSelectedItem("<any>");
        }
        if (!(value instanceof Boolean)) {
            return;
        }
        Boolean bvalue = (Boolean)value;
        if (bvalue.booleanValue()) {
            this.setSelectedItem("true");
        } else {
            this.setSelectedItem("false");
        }
    }

    @Override
    public void setAllowedValues(Collection<Object> allowedValues) {
        boolean containTrue = false;
        boolean containFalse = false;
        for (Object o : allowedValues) {
            Boolean bool = (Boolean)o;
            if (!containTrue) {
                containTrue = bool;
            }
            if (containFalse) continue;
            boolean bl = containFalse = bool == false;
        }
        if (!containTrue) {
            this.removeItem("true");
        }
        if (!containFalse) {
            this.removeItem("false");
        }
    }
}

