/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.maintenance;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jcolibri.cbrcore.CBRCase;
import jcolibri.exception.InitializingException;
import jcolibri.method.maintenance.SolvesFunction;
import jcolibri.method.reuse.classification.KNNClassificationConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompetenceModel {
    private Map<CBRCase, Collection<CBRCase>> coverageSets;
    private Map<CBRCase, Collection<CBRCase>> reachabilitySets;
    private Map<CBRCase, Collection<CBRCase>> liabilitySets;

    public void computeCompetenceModel(SolvesFunction solves, KNNClassificationConfig knnConfig, Collection<CBRCase> cases) {
        this.coverageSets = new HashMap<CBRCase, Collection<CBRCase>>();
        this.reachabilitySets = new HashMap<CBRCase, Collection<CBRCase>>();
        this.liabilitySets = new HashMap<CBRCase, Collection<CBRCase>>();
        for (CBRCase q : cases) {
            solves.setCasesThatSolveAndMisclassifyQ(q, cases, knnConfig);
            Collection<CBRCase> solveQ = solves.getCasesThatSolvedQuery();
            Collection<CBRCase> misclassifyQ = solves.getCasesThatMisclassifiedQuery();
            LinkedList<CBRCase> reachabilitySet = new LinkedList<CBRCase>();
            if (solveQ != null) {
                for (CBRCase c : solveQ) {
                    reachabilitySet.add(c);
                    Collection<CBRCase> coverageSet = this.coverageSets.get(c);
                    if (coverageSet == null) {
                        coverageSet = new LinkedList<CBRCase>();
                    }
                    coverageSet.add(q);
                    this.coverageSets.put(c, coverageSet);
                }
                this.reachabilitySets.put(q, reachabilitySet);
            }
            if (misclassifyQ == null) continue;
            for (CBRCase c : misclassifyQ) {
                Collection<CBRCase> liabilitySet = this.liabilitySets.get(c);
                if (liabilitySet == null) {
                    liabilitySet = new LinkedList<CBRCase>();
                }
                liabilitySet.add(q);
                this.liabilitySets.put(c, liabilitySet);
            }
        }
    }

    public Collection<CBRCase> getCoverageSet(CBRCase c) throws InitializingException {
        if (this.coverageSets == null) {
            throw new InitializingException();
        }
        return this.coverageSets.get(c);
    }

    public Collection<CBRCase> getReachabilitySet(CBRCase c) throws InitializingException {
        if (this.reachabilitySets == null) {
            throw new InitializingException();
        }
        return this.reachabilitySets.get(c);
    }

    public Collection<CBRCase> getLiabilitySet(CBRCase c) throws InitializingException {
        if (this.liabilitySets == null) {
            throw new InitializingException();
        }
        return this.liabilitySets.get(c);
    }

    public Map<CBRCase, Collection<CBRCase>> getCoverageSets() {
        return this.coverageSets;
    }

    public Map<CBRCase, Collection<CBRCase>> getReachabilitySets() {
        return this.reachabilitySets;
    }

    public Map<CBRCase, Collection<CBRCase>> getLiabilitySets() {
        return this.liabilitySets;
    }
}

