/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.maintenance.algorithms;

import java.util.Collection;
import java.util.LinkedList;
import jcolibri.cbrcore.CBRCase;
import jcolibri.exception.InitializingException;
import jcolibri.method.maintenance.AbstractCaseBaseEditMethod;
import jcolibri.method.maintenance.CompetenceModel;
import jcolibri.method.maintenance.solvesFunctions.CBESolvesFunction;
import jcolibri.method.reuse.classification.KNNClassificationConfig;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RCRedundancyRemoval
extends AbstractCaseBaseEditMethod {
    @Override
    public Collection<CBRCase> retrieveCasesToDelete(Collection<CBRCase> cases, KNNClassificationConfig simConfig) {
        ProgressController.init(this.getClass(), "RC Redundancy Removal", -1);
        LinkedList<CBRCase> localCases = new LinkedList<CBRCase>();
        for (CBRCase c : cases) {
            localCases.add(c);
        }
        CompetenceModel sc = new CompetenceModel();
        LinkedList<CBRCase> keepCases = new LinkedList<CBRCase>();
        while (localCases.size() > 0) {
            double topRCScore = 0.0;
            CBRCase topRCCase = null;
            sc.computeCompetenceModel(new CBESolvesFunction(), simConfig, localCases);
            try {
                for (CBRCase c : localCases) {
                    double rcScore = 0.0;
                    Collection<CBRCase> cCov = sc.getCoverageSet(c);
                    for (CBRCase c1 : cCov) {
                        rcScore += 1.0 / (double)sc.getReachabilitySet(c1).size();
                    }
                    if (!(rcScore > topRCScore)) continue;
                    topRCScore = rcScore;
                    topRCCase = c;
                }
                keepCases.add(topRCCase);
                Collection<CBRCase> cSet = sc.getCoverageSet(topRCCase);
                LinkedList<CBRCase> toRemove = new LinkedList<CBRCase>();
                for (CBRCase c : cSet) {
                    toRemove.add(c);
                }
                localCases.removeAll(toRemove);
            }
            catch (InitializingException e) {
                LogFactory.getLog(this.getClass()).error((Object)e);
            }
            ProgressController.step(this.getClass());
        }
        LinkedList<CBRCase> allCasesToBeRemoved = new LinkedList<CBRCase>();
        for (CBRCase c : cases) {
            if (keepCases.contains(c)) continue;
            allCasesToBeRemoved.add(c);
        }
        ProgressController.finish(this.getClass());
        return allCasesToBeRemoved;
    }
}

