/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.NNretrieval.similarity.local;

import jcolibri.exception.NoApplicableSimilarityFunctionException;
import jcolibri.method.retrieve.NNretrieval.similarity.LocalSimilarityFunction;

public class MaxString
implements LocalSimilarityFunction {
    public double compute(Object s, Object t) throws NoApplicableSimilarityFunctionException {
        if (s == null || t == null) {
            return 0.0;
        }
        if (!(s instanceof String)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), s.getClass());
        }
        if (!(t instanceof String)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), s.getClass());
        }
        String news = (String)s;
        String newt = (String)t;
        if (news.equals(newt)) {
            return 1.0;
        }
        return (double)this.MaxSubString(news, newt) / (double)Math.max(news.length(), newt.length());
    }

    private int MaxSubString(String s, String t) {
        String shorter = s.length() > t.length() ? t : s;
        String longer = shorter.equals(s) ? t : s;
        int best = 0;
        int i = 0;
        while (i < shorter.length()) {
            int j = shorter.length();
            while (j > i) {
                if (longer.indexOf(shorter.substring(i, j)) != -1) {
                    best = Math.max(best, j - i);
                }
                --j;
            }
            ++i;
        }
        return best;
    }

    public boolean isApplicable(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return o2 instanceof String;
        }
        if (o2 == null) {
            return o1 instanceof String;
        }
        return o1 instanceof String && o2 instanceof String;
    }
}

