/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.NNretrieval.similarity.local.ontology;

import es.ucm.fdi.gaia.ontobridge.OntoBridge;
import es.ucm.fdi.gaia.ontobridge.OntologyDocument;
import java.util.ArrayList;
import jcolibri.datatypes.Instance;
import jcolibri.exception.NoApplicableSimilarityFunctionException;
import jcolibri.method.retrieve.NNretrieval.similarity.LocalSimilarityFunction;
import jcolibri.util.FileIO;
import jcolibri.util.OntoBridgeSingleton;
import org.apache.commons.logging.LogFactory;

public class OntDeepBasic
implements LocalSimilarityFunction {
    public double compute(Object caseObject, Object queryObject) throws NoApplicableSimilarityFunctionException {
        if (caseObject == null || queryObject == null) {
            return 0.0;
        }
        if (!(caseObject instanceof Instance)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), caseObject.getClass());
        }
        if (!(queryObject instanceof Instance)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), queryObject.getClass());
        }
        Instance i1 = (Instance)caseObject;
        Instance i2 = (Instance)queryObject;
        if (i1.equals(i2)) {
            return 1.0;
        }
        OntoBridge ob = OntoBridgeSingleton.getOntoBridge();
        double up = ob.maxProfLCS(i1.toString(), i2.toString());
        double down = ob.getMaxProf();
        return up / down;
    }

    public boolean isApplicable(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return o2 instanceof Instance;
        }
        if (o2 == null) {
            return o1 instanceof Instance;
        }
        return o1 instanceof Instance && o2 instanceof Instance;
    }

    public static void main(String[] args) {
        try {
            OntoBridge ob = OntoBridgeSingleton.getOntoBridge();
            ob.initWithPelletReasoner();
            OntologyDocument mainOnto = new OntologyDocument("http://gaia.fdi.ucm.es/ontologies/vacation.owl", FileIO.findFile("jcolibri/test/test5/vacation.owl").toExternalForm());
            ArrayList subOntologies = new ArrayList();
            ob.loadOntology(mainOnto, subOntologies, false);
            OntDeepBasic sim = new OntDeepBasic();
            System.out.println("deep_basic(CAR,TRAIN)=" + sim.compute(new Instance("CAR"), new Instance("TRAIN")));
            System.out.println("deep_basic(CAR,IBIZA)=" + sim.compute(new Instance("CAR"), new Instance("IBIZA")));
            System.out.println("deep_basic(CAR,I101)=" + sim.compute(new Instance("CAR"), new Instance("I101")));
        }
        catch (Exception e) {
            LogFactory.getLog(OntDeepBasic.class).error((Object)e);
        }
    }
}

