/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.reuse.classification;

import java.util.Collection;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.extensions.classification.ClassificationSolution;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.reuse.classification.KNNClassificationMethod;
import jcolibri.util.CopyUtils;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKNNClassificationMethod
implements KNNClassificationMethod {
    @Override
    public abstract ClassificationSolution getPredictedSolution(Collection<RetrievalResult> var1);

    @Override
    public CBRCase getPredictedCase(CBRQuery query, Collection<RetrievalResult> cases) {
        CBRCase queryWithPredSoln = null;
        if (cases.size() > 0) {
            CBRCase c = cases.iterator().next().get_case();
            try {
                queryWithPredSoln = (CBRCase)c.getClass().newInstance();
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).error((Object)e);
            }
            queryWithPredSoln.setDescription(CopyUtils.copyCaseComponent(query.getDescription()));
            ClassificationSolution predSolution = this.getPredictedSolution(cases);
            queryWithPredSoln.setSolution(predSolution);
            queryWithPredSoln.setJustificationOfSolution(null);
            queryWithPredSoln.setResult(null);
        }
        return queryWithPredSoln;
    }
}

